/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.io.IOException;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.apache.hive.service.auth.ldap.UserFilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestUserFilter {
    private FilterFactory factory;
    private HiveConf conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.factory = new UserFilterFactory();
    }

    @Test
    public void testFactory() {
        this.conf.unset(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER.varname);
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1");
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testApplyPositive() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1,User2,uSeR3");
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User1");
        filter.apply(this.search, "uid=user2,ou=People,dc=example,dc=com");
        filter.apply(this.search, "User3@mydomain.com");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyNegative() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1,User2");
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User3");
    }
}

