/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSessionGlobalInitFile
extends TestCase {
    private FakeEmbeddedThriftBinaryCLIService service;
    private ThriftCLIServiceClient client;
    private File initFile;
    private String tmpDir;
    private HiveConf hiveConf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initFile = File.createTempFile("test", "hive");
        this.tmpDir = this.initFile.getParentFile().getAbsoluteFile() + File.separator + "TestSessionGlobalInitFile";
        this.initFile.delete();
        FileUtils.deleteDirectory((File)new File(this.tmpDir));
        this.initFile = new File(this.tmpDir + File.separator + ".hiverc");
        this.initFile.getParentFile().mkdirs();
        this.initFile.createNewFile();
        String[] fileContent = new String[]{"-- global init hive file for test", "set a=1;", "set hiveconf:b=1;", "set hivevar:c=1;", "set d\\", "      =1;", "add jar " + this.initFile.getAbsolutePath()};
        FileUtils.writeLines((File)this.initFile, Arrays.asList(fileContent));
        this.hiveConf = new HiveConf();
        this.hiveConf.set("fs.default.name", "file:///");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_GLOBAL_INIT_FILE_LOCATION, this.initFile.getParentFile().getAbsolutePath());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.service = new FakeEmbeddedThriftBinaryCLIService(this.hiveConf);
        this.service.init(new HiveConf());
        this.client = new ThriftCLIServiceClient((TCLIService.Iface)this.service);
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(this.tmpDir));
    }

    @Test
    public void testSessionGlobalInitFile() throws Exception {
        File tmpInitFile = new File(this.initFile.getParent(), "hiverc");
        Assert.assertTrue((String)("Failed to rename " + this.initFile + " to " + tmpInitFile), (boolean)this.initFile.renameTo(tmpInitFile));
        this.initFile = tmpInitFile;
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_GLOBAL_INIT_FILE_LOCATION, this.initFile.getAbsolutePath());
        this.doTestSessionGlobalInitFile();
    }

    @Test
    public void testSessionGlobalInitDir() throws Exception {
        this.doTestSessionGlobalInitFile();
    }

    private void doTestSessionGlobalInitFile() throws Exception {
        OperationManager operationManager = this.service.getService().getSessionManager().getOperationManager();
        SessionHandle sessionHandle = this.client.openSession(null, null, null);
        Assert.assertEquals((String)"Verifying all operations used for init file are closed", (long)0L, (long)operationManager.getOperations().size());
        this.verifyInitProperty("a", "1", sessionHandle);
        this.verifyInitProperty("b", "1", sessionHandle);
        this.verifyInitProperty("c", "1", sessionHandle);
        this.verifyInitProperty("hivevar:c", "1", sessionHandle);
        this.verifyInitProperty("d", "1", sessionHandle);
        Assert.assertEquals((String)"Verifying all operations used for checks are closed", (long)0L, (long)operationManager.getOperations().size());
        this.client.closeSession(sessionHandle);
    }

    @Test
    public void testSessionGlobalInitFileWithUser() throws Exception {
        SessionHandle sessionHandle = this.client.openSession("hive", "password", null);
        this.verifyInitProperty("a", "1", sessionHandle);
        this.client.closeSession(sessionHandle);
    }

    @Test
    public void testSessionGlobalInitFileAndConfOverlay() throws Exception {
        HashMap<String, String> confOverlay = new HashMap<String, String>();
        confOverlay.put("a", "2");
        confOverlay.put("set:hiveconf:b", "2");
        confOverlay.put("set:hivevar:c", "2");
        SessionHandle sessionHandle = this.client.openSession(null, null, confOverlay);
        this.verifyInitProperty("a", "2", sessionHandle);
        this.verifyInitProperty("b", "2", sessionHandle);
        this.verifyInitProperty("c", "2", sessionHandle);
        this.client.closeSession(sessionHandle);
        sessionHandle = this.client.openSession("hive", "password", confOverlay);
        this.verifyInitProperty("a", "2", sessionHandle);
        this.client.closeSession(sessionHandle);
    }

    private void verifyInitProperty(String key, String value, SessionHandle sessionHandle) throws Exception {
        OperationHandle operationHandle = this.client.executeStatement(sessionHandle, "set " + key, null);
        RowSet rowSet = this.client.fetchResults(operationHandle);
        Assert.assertEquals((long)1L, (long)rowSet.numRows());
        Assert.assertEquals((Object)(key + "=" + value), (Object)((Object[])rowSet.iterator().next())[0]);
        this.client.closeOperation(operationHandle);
    }

    private class FakeEmbeddedThriftBinaryCLIService
    extends ThriftBinaryCLIService {
        public FakeEmbeddedThriftBinaryCLIService(HiveConf hiveConf) {
            super(new CLIService(null), null);
            this.isEmbedded = true;
            this.cliService.init(hiveConf);
            this.cliService.start();
        }

        public CLIService getService() {
            return this.cliService;
        }
    }
}

