/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.Service;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.thrift.RetryingThriftCLIServiceClient;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.HiveServer2;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRetryingThriftCLIServiceClient {
    protected static ThriftCLIService service;
    private HiveConf hiveConf;
    private HiveServer2 server;

    @Before
    public void init() {
        this.hiveConf = new HiveConf();
        this.hiveConf.set("fs.default.name", "file:///");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, "localhost");
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 15000);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION, HiveAuthFactory.AuthTypes.NONE.toString());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE, "binary");
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_RETRY_LIMIT, 3);
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 3);
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS, 10);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT, "1s");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
    }

    private void startHiveServer() throws InterruptedException {
        this.server = new HiveServer2();
        this.server.init(this.hiveConf);
        this.server.start();
        Thread.sleep(5000L);
        System.out.println("## HiveServer started");
    }

    private void stopHiveServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testRetryBehaviour() throws Exception {
        this.startHiveServer();
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 17000);
        try {
            RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(this.hiveConf);
            Assert.fail((String)"Expected to throw exception for invalid port");
        }
        catch (HiveSQLException sqlExc) {
            Assert.assertTrue((boolean)(sqlExc.getCause() instanceof TTransportException));
            Assert.assertTrue((boolean)sqlExc.getMessage().contains("3"));
        }
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 15000);
        RetryingThriftCLIServiceClient.CLIServiceClientWrapper cliServiceClient = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(this.hiveConf);
        System.out.println("## Created client");
        this.stopHiveServer();
        Thread.sleep(5000L);
        try {
            RetryingThriftCLIServiceClientTest.handlerInst.callCount = 0;
            RetryingThriftCLIServiceClientTest.handlerInst.connectCount = 0;
            cliServiceClient.openSession("anonymous", "anonymous");
        }
        catch (HiveSQLException exc) {
            exc.printStackTrace();
            Assert.assertTrue((boolean)(exc.getCause() instanceof TException));
            Assert.assertEquals((long)1L, (long)RetryingThriftCLIServiceClientTest.handlerInst.callCount);
            Assert.assertEquals((long)3L, (long)RetryingThriftCLIServiceClientTest.handlerInst.connectCount);
        }
        finally {
            cliServiceClient.closeTransport();
        }
    }

    @Test
    public void testTransportClose() throws InterruptedException, HiveSQLException {
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 0);
        try {
            this.startHiveServer();
            RetryingThriftCLIServiceClient.CLIServiceClientWrapper client = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(this.hiveConf);
            client.closeTransport();
            try {
                client.openSession("anonymous", "anonymous");
                Assert.fail((String)"Shouldn't be able to open session when transport is closed.");
            }
            catch (HiveSQLException hiveSQLException) {
                // empty catch block
            }
        }
        finally {
            this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 3);
            this.stopHiveServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionLifeAfterTransportClose() throws InterruptedException, HiveSQLException {
        try {
            this.startHiveServer();
            CLIService service = null;
            for (Service s : this.server.getServices()) {
                if (!(s instanceof CLIService)) continue;
                service = (CLIService)s;
            }
            if (service == null) {
                service = new CLIService(this.server);
            }
            RetryingThriftCLIServiceClient.CLIServiceClientWrapper client = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(this.hiveConf);
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put(HiveConf.ConfVars.HIVE_SERVER2_CLOSE_SESSION_ON_DISCONNECT.varname, "false");
            SessionHandle sessionHandle = client.openSession("anonymous", "anonymous", conf);
            Assert.assertNotNull((Object)sessionHandle);
            HiveSession session = service.getSessionManager().getSession(sessionHandle);
            OperationHandle op1 = session.executeStatementAsync("show databases", null);
            Assert.assertNotNull((Object)op1);
            client.closeTransport();
            Assert.assertEquals((Object)session, (Object)service.getSessionManager().getSession(sessionHandle));
            OperationHandle op2 = session.executeStatementAsync("show databases", null);
            Assert.assertNotNull((Object)op2);
            client = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(this.hiveConf);
            client.closeSession(sessionHandle);
            for (OperationHandle op : new OperationHandle[]{op1, op2}) {
                try {
                    client.getOperationStatus(op, false);
                    Assert.fail((String)"Should have failed.");
                }
                catch (HiveSQLException hiveSQLException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.stopHiveServer();
        }
    }

    static class RetryingThriftCLIServiceClientTest
    extends RetryingThriftCLIServiceClient {
        int callCount = 0;
        int connectCount = 0;
        static RetryingThriftCLIServiceClientTest handlerInst;

        protected RetryingThriftCLIServiceClientTest(HiveConf conf) {
            super(conf);
        }

        public static RetryingThriftCLIServiceClient.CLIServiceClientWrapper newRetryingCLIServiceClient(HiveConf conf) throws HiveSQLException {
            handlerInst = new RetryingThriftCLIServiceClientTest(conf);
            TTransport tTransport = handlerInst.connectWithRetry(conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_RETRY_LIMIT));
            ICLIService cliService = (ICLIService)Proxy.newProxyInstance(RetryingThriftCLIServiceClientTest.class.getClassLoader(), CLIServiceClient.class.getInterfaces(), (InvocationHandler)((Object)handlerInst));
            return new RetryingThriftCLIServiceClient.CLIServiceClientWrapper(cliService, tTransport, conf);
        }

        protected RetryingThriftCLIServiceClient.InvocationResult invokeInternal(Method method, Object[] args) throws Throwable {
            System.out.println("## Calling: " + method.getName() + ", " + this.callCount + "/" + this.getRetryLimit());
            ++this.callCount;
            return super.invokeInternal(method, args);
        }

        protected synchronized TTransport connect(HiveConf conf) throws HiveSQLException, TTransportException {
            ++this.connectCount;
            return super.connect(conf);
        }
    }
}

