/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.hive.service.auth.ldap.LdapTestUtils;
import org.apache.hive.service.auth.ldap.SearchResultHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestSearchResultHandler {
    SearchResultHandler handler;

    @Test
    public void testHandle() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addSearchResultWithDns("1").addSearchResultWithDns("2", "3");
        this.handler = new SearchResultHandler((Collection)resultCollection);
        List<String> expected = Arrays.asList("1", "2");
        final ArrayList actual = new ArrayList();
        this.handler.handle(new SearchResultHandler.RecordProcessor(){

            public boolean process(SearchResult record) throws NamingException {
                actual.add(record.getNameInNamespace());
                return actual.size() < 2;
            }
        });
        Assert.assertEquals(expected, actual);
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testGetAllLdapNamesNoRecords() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addEmptySearchResult();
        this.handler = new SearchResultHandler((Collection)resultCollection);
        List actual = this.handler.getAllLdapNames();
        Assert.assertEquals((String)"Resultset size", (long)0L, (long)actual.size());
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testGetAllLdapNamesWithExceptionInNamingEnumerationClose() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addSearchResultWithDns("1").addSearchResultWithDns("2");
        ((NamingEnumeration)Mockito.doThrow(NamingException.class).when(resultCollection.iterator().next())).close();
        this.handler = new SearchResultHandler((Collection)resultCollection);
        List actual = this.handler.getAllLdapNames();
        Assert.assertEquals((String)"Resultset size", (long)2L, (long)actual.size());
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testGetAllLdapNames() throws NamingException {
        String objectDn1 = "cn=a1,dc=b,dc=c";
        String objectDn2 = "cn=a2,dc=b,dc=c";
        String objectDn3 = "cn=a3,dc=b,dc=c";
        MockResultCollection resultCollection = MockResultCollection.create().addSearchResultWithDns(objectDn1).addSearchResultWithDns(objectDn2, objectDn3);
        this.handler = new SearchResultHandler((Collection)resultCollection);
        List<String> expected = Arrays.asList(objectDn1, objectDn2, objectDn3);
        Collections.sort(expected);
        List actual = this.handler.getAllLdapNames();
        Collections.sort(actual);
        Assert.assertEquals(expected, (Object)actual);
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testGetAllLdapNamesAndAttributes() throws NamingException {
        SearchResult searchResult1 = LdapTestUtils.mockSearchResult("cn=a1,dc=b,dc=c", LdapTestUtils.mockAttributes("attr1", "attr1value1"));
        SearchResult searchResult2 = LdapTestUtils.mockSearchResult("cn=a2,dc=b,dc=c", LdapTestUtils.mockAttributes("attr1", "attr1value2", "attr2", "attr2value1"));
        SearchResult searchResult3 = LdapTestUtils.mockSearchResult("cn=a3,dc=b,dc=c", LdapTestUtils.mockAttributes("attr1", "attr1value3", "attr1", "attr1value4"));
        SearchResult searchResult4 = LdapTestUtils.mockSearchResult("cn=a4,dc=b,dc=c", LdapTestUtils.mockEmptyAttributes());
        MockResultCollection resultCollection = MockResultCollection.create().addSearchResults(searchResult1).addSearchResults(searchResult2, searchResult3).addSearchResults(searchResult4);
        this.handler = new SearchResultHandler((Collection)resultCollection);
        List<String> expected = Arrays.asList("cn=a1,dc=b,dc=c", "attr1value1", "cn=a2,dc=b,dc=c", "attr1value2", "attr2value1", "cn=a3,dc=b,dc=c", "attr1value3", "attr1value4", "cn=a4,dc=b,dc=c");
        Collections.sort(expected);
        List actual = this.handler.getAllLdapNamesAndAttributes();
        Collections.sort(actual);
        Assert.assertEquals(expected, (Object)actual);
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testHasSingleResultNoRecords() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addEmptySearchResult();
        this.handler = new SearchResultHandler((Collection)resultCollection);
        Assert.assertFalse((boolean)this.handler.hasSingleResult());
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testHasSingleResult() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addSearchResultWithDns("1");
        this.handler = new SearchResultHandler((Collection)resultCollection);
        Assert.assertTrue((boolean)this.handler.hasSingleResult());
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test
    public void testHasSingleResultManyRecords() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addSearchResultWithDns("1").addSearchResultWithDns("2");
        this.handler = new SearchResultHandler((Collection)resultCollection);
        Assert.assertFalse((boolean)this.handler.hasSingleResult());
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    @Test(expected=NamingException.class)
    public void testGetSingleLdapNameNoRecords() throws NamingException {
        MockResultCollection resultCollection = MockResultCollection.create().addEmptySearchResult();
        this.handler = new SearchResultHandler((Collection)resultCollection);
        try {
            this.handler.getSingleLdapName();
        }
        finally {
            this.assertAllNamingEnumerationsClosed(resultCollection);
        }
    }

    @Test
    public void testGetSingleLdapName() throws NamingException {
        String objectDn = "cn=a,dc=b,dc=c";
        MockResultCollection resultCollection = MockResultCollection.create().addEmptySearchResult().addSearchResultWithDns(objectDn);
        this.handler = new SearchResultHandler((Collection)resultCollection);
        String expected = objectDn;
        String actual = this.handler.getSingleLdapName();
        Assert.assertEquals((Object)expected, (Object)actual);
        this.assertAllNamingEnumerationsClosed(resultCollection);
    }

    private void assertAllNamingEnumerationsClosed(MockResultCollection resultCollection) throws NamingException {
        for (NamingEnumeration<SearchResult> namingEnumeration : resultCollection) {
            ((NamingEnumeration)Mockito.verify(namingEnumeration, (VerificationMode)Mockito.atLeastOnce())).close();
        }
    }

    private static final class MockResultCollection
    extends AbstractCollection<NamingEnumeration<SearchResult>> {
        List<NamingEnumeration<SearchResult>> results = new ArrayList<NamingEnumeration<SearchResult>>();

        private MockResultCollection() {
        }

        static MockResultCollection create() {
            return new MockResultCollection();
        }

        MockResultCollection addSearchResultWithDns(String ... dns) throws NamingException {
            this.results.add(LdapTestUtils.mockNamingEnumeration(dns));
            return this;
        }

        MockResultCollection addSearchResults(SearchResult ... dns) throws NamingException {
            this.results.add(LdapTestUtils.mockNamingEnumeration(dns));
            return this;
        }

        MockResultCollection addEmptySearchResult() throws NamingException {
            this.addSearchResults(new SearchResult[0]);
            return this;
        }

        @Override
        public Iterator<NamingEnumeration<SearchResult>> iterator() {
            return this.results.iterator();
        }

        @Override
        public int size() {
            return this.results.size();
        }
    }
}

