/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.LdapSearch;
import org.apache.hive.service.auth.ldap.LdapTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestLdapSearch {
    @Mock
    private DirContext ctx;
    private HiveConf conf;
    private LdapSearch search;

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERMEMBERSHIP_KEY, "memberOf");
    }

    @Test
    public void testClose() throws NamingException {
        this.search = new LdapSearch(this.conf, this.ctx);
        this.search.close();
        ((DirContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testFindUserDnWhenUserDnPositive() throws NamingException {
        NamingEnumeration<SearchResult> searchResult = LdapTestUtils.mockNamingEnumeration("CN=User1,OU=org1,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(searchResult).thenThrow(new Class[]{NamingException.class});
        this.search = new LdapSearch(this.conf, this.ctx);
        String expected = "CN=User1,OU=org1,DC=foo,DC=bar";
        String actual = this.search.findUserDn("CN=User1,OU=org1");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindUserDnWhenUserDnNegativeDuplicates() throws NamingException {
        NamingEnumeration<SearchResult> searchResult = LdapTestUtils.mockNamingEnumeration("CN=User1,OU=org1,DC=foo,DC=bar", "CN=User1,OU=org2,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(searchResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        Assert.assertNull((Object)this.search.findUserDn("CN=User1,DC=foo,DC=bar"));
    }

    @Test
    public void testFindUserDnWhenUserDnNegativeNone() throws NamingException {
        NamingEnumeration<SearchResult> searchResult = LdapTestUtils.mockEmptyNamingEnumeration();
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(searchResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        Assert.assertNull((Object)this.search.findUserDn("CN=User1,DC=foo,DC=bar"));
    }

    @Test
    public void testFindUserDnWhenUserPatternFoundBySecondPattern() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar:CN=%s,OU=org2,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> emptyResult = LdapTestUtils.mockEmptyNamingEnumeration();
        NamingEnumeration<SearchResult> validResult = LdapTestUtils.mockNamingEnumeration("CN=User1,OU=org2,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(emptyResult).thenReturn(validResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        String expected = "CN=User1,OU=org2,DC=foo,DC=bar";
        String actual = this.search.findUserDn("User1");
        Assert.assertEquals((Object)expected, (Object)actual);
        ((DirContext)Mockito.verify((Object)this.ctx)).search((String)Mockito.eq((Object)"OU=org1,DC=foo,DC=bar"), Mockito.contains((String)"CN=User1"), (SearchControls)Mockito.any(SearchControls.class));
        ((DirContext)Mockito.verify((Object)this.ctx)).search((String)Mockito.eq((Object)"OU=org2,DC=foo,DC=bar"), Mockito.contains((String)"CN=User1"), (SearchControls)Mockito.any(SearchControls.class));
    }

    @Test
    public void testFindUserDnWhenUserPatternFoundByFirstPattern() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar:CN=%s,OU=org2,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> emptyResult = LdapTestUtils.mockEmptyNamingEnumeration();
        NamingEnumeration<SearchResult> validResult = LdapTestUtils.mockNamingEnumeration("CN=User1,OU=org2,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(validResult).thenReturn(emptyResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        String expected = "CN=User1,OU=org2,DC=foo,DC=bar";
        String actual = this.search.findUserDn("User1");
        Assert.assertEquals((Object)expected, (Object)actual);
        ((DirContext)Mockito.verify((Object)this.ctx)).search((String)Mockito.eq((Object)"OU=org1,DC=foo,DC=bar"), Mockito.contains((String)"CN=User1"), (SearchControls)Mockito.any(SearchControls.class));
    }

    @Test
    public void testFindUserDnWhenUserPatternFoundByUniqueIdentifier() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> validResult = LdapTestUtils.mockNamingEnumeration("CN=User1,OU=org1,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(null).thenReturn(validResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        String expected = "CN=User1,OU=org1,DC=foo,DC=bar";
        String actual = this.search.findUserDn("User1");
        Assert.assertEquals((Object)expected, (Object)actual);
        ((DirContext)Mockito.verify((Object)this.ctx)).search((String)Mockito.eq((Object)"OU=org1,DC=foo,DC=bar"), Mockito.contains((String)"CN=User1"), (SearchControls)Mockito.any(SearchControls.class));
        ((DirContext)Mockito.verify((Object)this.ctx)).search((String)Mockito.eq((Object)"OU=org1,DC=foo,DC=bar"), Mockito.contains((String)"uid=User1"), (SearchControls)Mockito.any(SearchControls.class));
    }

    @Test
    public void testFindUserDnWhenUserPatternFoundByUniqueIdentifierNegativeNone() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(null).thenReturn(null);
        this.search = new LdapSearch(this.conf, this.ctx);
        Assert.assertNull((Object)this.search.findUserDn("User1"));
    }

    @Test
    public void testFindUserDnWhenUserPatternFoundByUniqueIdentifierNegativeMany() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> manyResult = LdapTestUtils.mockNamingEnumeration("CN=User1,OU=org1,DC=foo,DC=bar", "CN=User12,OU=org1,DC=foo,DC=bar");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(null).thenReturn(manyResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        Assert.assertNull((Object)this.search.findUserDn("User1"));
    }

    @Test
    public void testFindGroupsForUser() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> groupsResult = LdapTestUtils.mockNamingEnumeration("CN=Group1,OU=org1,DC=foo,DC=bar");
        Mockito.when(this.ctx.search((String)Mockito.eq((Object)"OU=org1,DC=foo,DC=bar"), Mockito.contains((String)"User1"), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(groupsResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        List<String> expected = Arrays.asList("CN=Group1,OU=org1,DC=foo,DC=bar");
        List actual = this.search.findGroupsForUser("CN=User1,OU=org1,DC=foo,DC=bar");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteCustomQuery() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=example,dc=com");
        NamingEnumeration<SearchResult> customQueryResult = LdapTestUtils.mockNamingEnumeration(LdapTestUtils.mockSearchResult("uid=group1,ou=Groups,dc=example,dc=com", LdapTestUtils.mockAttributes("member", "uid=user1,ou=People,dc=example,dc=com")), LdapTestUtils.mockSearchResult("uid=group2,ou=Groups,dc=example,dc=com", LdapTestUtils.mockAttributes("member", "uid=user2,ou=People,dc=example,dc=com")));
        Mockito.when(this.ctx.search((String)Mockito.eq((Object)"dc=example,dc=com"), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(customQueryResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        List<String> expected = Arrays.asList("uid=group1,ou=Groups,dc=example,dc=com", "uid=user1,ou=People,dc=example,dc=com", "uid=group2,ou=Groups,dc=example,dc=com", "uid=user2,ou=People,dc=example,dc=com");
        List actual = this.search.executeCustomQuery("(&(objectClass=groupOfNames)(|(cn=group1)(cn=group2)))");
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testFindGroupDnPositive() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        String groupDn = "CN=Group1";
        NamingEnumeration<SearchResult> result = LdapTestUtils.mockNamingEnumeration(groupDn);
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(result);
        this.search = new LdapSearch(this.conf, this.ctx);
        String expected = groupDn;
        String actual = this.search.findGroupDn("grp1");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=NamingException.class)
    public void testFindGroupDNNoResults() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> result = LdapTestUtils.mockEmptyNamingEnumeration();
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(result);
        this.search = new LdapSearch(this.conf, this.ctx);
        this.search.findGroupDn("anyGroup");
    }

    @Test(expected=NamingException.class)
    public void testFindGroupDNTooManyResults() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> result = LdapTestUtils.mockNamingEnumeration("Result1", "Result2", "Result3");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(result);
        this.search = new LdapSearch(this.conf, this.ctx);
        this.search.findGroupDn("anyGroup");
    }

    @Test
    public void testFindGroupDNWhenExceptionInSearch() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN, Joiner.on((String)":").join((Object)"CN=%s,OU=org1,DC=foo,DC=bar", (Object)"CN=%s,OU=org2,DC=foo,DC=bar", new Object[0]));
        NamingEnumeration<SearchResult> result = LdapTestUtils.mockNamingEnumeration("CN=Group1");
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(result).thenThrow(new Class[]{NamingException.class});
        this.search = new LdapSearch(this.conf, this.ctx);
        String expected = "CN=Group1";
        String actual = this.search.findGroupDn("grp1");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsUserMemberOfGroupWhenUserId() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> validResult = LdapTestUtils.mockNamingEnumeration("CN=User1");
        NamingEnumeration<SearchResult> emptyResult = LdapTestUtils.mockEmptyNamingEnumeration();
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.contains((String)"(uid=usr1)"), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(validResult);
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.contains((String)"(uid=usr2)"), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(emptyResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        Assert.assertTrue((boolean)this.search.isUserMemberOfGroup("usr1", "grp1"));
        Assert.assertFalse((boolean)this.search.isUserMemberOfGroup("usr2", "grp2"));
    }

    @Test
    public void testIsUserMemberOfGroupWhenUserDn() throws NamingException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "CN=%s,OU=org1,DC=foo,DC=bar");
        NamingEnumeration<SearchResult> validResult = LdapTestUtils.mockNamingEnumeration("CN=User1");
        NamingEnumeration<SearchResult> emptyResult = LdapTestUtils.mockEmptyNamingEnumeration();
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.contains((String)"(uid=User1)"), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(validResult);
        Mockito.when(this.ctx.search(Mockito.anyString(), Mockito.contains((String)"(uid=User2)"), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(emptyResult);
        this.search = new LdapSearch(this.conf, this.ctx);
        Assert.assertTrue((boolean)this.search.isUserMemberOfGroup("CN=User1,OU=org1,DC=foo,DC=bar", "grp1"));
        Assert.assertFalse((boolean)this.search.isUserMemberOfGroup("CN=User2,OU=org1,DC=foo,DC=bar", "grp2"));
    }
}

