/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.Arrays;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThreadPoolExecutorWithOomHook;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpServlet;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ThriftHttpCLIService
extends ThriftCLIService {
    private final Runnable oomHook;

    public ThriftHttpCLIService(CLIService cliService, Runnable oomHook) {
        super(cliService, ThriftHttpCLIService.class.getSimpleName());
        this.oomHook = oomHook;
    }

    @Override
    public void run() {
        try {
            ServerConnector connector;
            String schemeName;
            String threadPoolName = "HiveServer2-HttpHandler-Pool";
            ThreadPoolExecutorWithOomHook threadPoolExecutorWithOomHook = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup(threadPoolName), this.oomHook);
            ExecutorThreadPool threadPool = new ExecutorThreadPool((ThreadPoolExecutor)threadPoolExecutorWithOomHook);
            this.httpServer = new Server((ThreadPool)threadPool);
            HttpConfiguration conf = new HttpConfiguration();
            conf.setSendServerVersion(false);
            int requestHeaderSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_REQUEST_HEADER_SIZE);
            int responseHeaderSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_RESPONSE_HEADER_SIZE);
            conf.setRequestHeaderSize(requestHeaderSize);
            conf.setResponseHeaderSize(responseHeaderSize);
            HttpConnectionFactory http = new HttpConnectionFactory(conf);
            boolean useSsl = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL);
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                String keyStorePassword = ShimLoader.getHadoopShims().getPassword((Configuration)this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname);
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                Object[] excludedProtocols = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",");
                LOG.info("HTTP Server SSL: adding excluded protocols: " + Arrays.toString(excludedProtocols));
                sslContextFactory.addExcludeProtocols((String[])excludedProtocols);
                LOG.info("HTTP Server SSL: SslContextFactory.getExcludeProtocols = " + Arrays.toString(sslContextFactory.getExcludeProtocols()));
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                String sslProtocolVersion = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_VERSION);
                sslContextFactory.setProtocol(sslProtocolVersion);
                LOG.info(String.format("Current SSL protocol version is %s", sslProtocolVersion));
                connector = new ServerConnector(this.httpServer, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{http});
            } else {
                connector = new ServerConnector(this.httpServer, new ConnectionFactory[]{http});
            }
            connector.setPort(this.portNum);
            connector.setReuseAddress(true);
            int maxIdleTime = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_IDLE_TIME, TimeUnit.MILLISECONDS);
            connector.setIdleTimeout((long)maxIdleTime);
            this.httpServer.addConnector((Connector)connector);
            hiveAuthFactory = new HiveAuthFactory(this.hiveConf);
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            UserGroupInformation serviceUGI = this.cliService.getServiceUGI();
            UserGroupInformation httpUGI = this.cliService.getHttpUGI();
            String authType = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, authType, serviceUGI, httpUGI, hiveAuthFactory);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            if (this.hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false)) {
                LOG.debug("XSRF filter enabled");
            } else {
                LOG.warn("XSRF filter disabled");
            }
            String httpPath = this.getHttpPath(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
            this.httpServer.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            this.httpServer.start();
            String msg = "Started " + ThriftHttpCLIService.class.getSimpleName() + " in " + schemeName + " mode on port " + this.portNum + " path=" + httpPath + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
            LOG.info(msg);
            this.httpServer.join();
        }
        catch (Throwable t) {
            LOG.error("Error starting HiveServer2: could not start " + ThriftHttpCLIService.class.getSimpleName(), t);
            System.exit(-1);
        }
    }

    private String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }
}

