/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.junit.Assert;
import org.junit.Test;

public class TestPluggableHiveSessionImpl {
    @Test
    public void testSessionImpl() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.default.name", "file:///");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER.getDefaultValue());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_CLASSNAME, SampleHiveSessionImpl.class.getName());
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        CLIService cliService = new CLIService(null);
        cliService.init(hiveConf);
        ThriftBinaryCLIService service = new ThriftBinaryCLIService(cliService, null);
        service.init(hiveConf);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        SessionHandle sessionHandle = null;
        sessionHandle = client.openSession("tom", "password");
        Assert.assertEquals((Object)SampleHiveSessionImpl.class.getName(), (Object)service.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_CLASSNAME));
        HiveSession session = cliService.getSessionManager().getSession(sessionHandle);
        Assert.assertEquals((long)-1091633151L, (long)session.getNoOperationTime());
        client.closeSession(sessionHandle);
    }

    @Test
    public void testSessionImplWithUGI() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.default.name", "file:///");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER.getDefaultValue());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_WITH_UGI_CLASSNAME, SampleHiveSessionImplWithUGI.class.getName());
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, true);
        CLIService cliService = new CLIService(null);
        cliService.init(hiveConf);
        ThriftBinaryCLIService service = new ThriftBinaryCLIService(cliService, null);
        service.init(hiveConf);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        SessionHandle sessionHandle = null;
        sessionHandle = client.openSession("tom", "password");
        Assert.assertEquals((Object)SampleHiveSessionImplWithUGI.class.getName(), (Object)service.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_WITH_UGI_CLASSNAME));
        HiveSession session = cliService.getSessionManager().getSession(sessionHandle);
        Assert.assertEquals((long)-1091633150L, (long)session.getNoOperationTime());
        client.closeSession(sessionHandle);
    }

    public static class SampleHiveSessionImplWithUGI
    extends HiveSessionImplwithUGI {
        public static final int MAGIC_RETURN_VALUE = -1091633150;

        public SampleHiveSessionImplWithUGI(SessionHandle sessionHandle, TProtocolVersion protocol, String username, String password, HiveConf serverhiveConf, String ipAddress, String delegationToken) throws HiveSQLException {
            super(sessionHandle, protocol, username, password, serverhiveConf, ipAddress, delegationToken);
        }

        public long getNoOperationTime() {
            return -1091633150L;
        }
    }

    public static class SampleHiveSessionImpl
    extends HiveSessionImpl {
        public static final int MAGIC_RETURN_VALUE = -1091633151;

        public SampleHiveSessionImpl(SessionHandle sessionHandle, TProtocolVersion protocol, String username, String password, HiveConf serverhiveConf, String ipAddress) {
            super(sessionHandle, protocol, username, password, serverhiveConf, ipAddress);
        }

        public long getNoOperationTime() {
            return -1091633151L;
        }
    }
}

