/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.LdapUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLdapUtils {
    @Test
    public void testCreateCandidatePrincipalsForUserDn() {
        HiveConf conf = new HiveConf();
        String userDn = "cn=user1,ou=CORP,dc=mycompany,dc=com";
        List<String> expected = Arrays.asList(userDn);
        List actual = LdapUtils.createCandidatePrincipals((HiveConf)conf, (String)userDn);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipalsForUserWithDomain() {
        HiveConf conf = new HiveConf();
        String userWithDomain = "user1@mycompany.com";
        List<String> expected = Arrays.asList(userWithDomain);
        List actual = LdapUtils.createCandidatePrincipals((HiveConf)conf, (String)userWithDomain);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipalsLdapDomain() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN, "mycompany.com");
        List<String> expected = Arrays.asList("user1@mycompany.com");
        List actual = LdapUtils.createCandidatePrincipals((HiveConf)conf, (String)"user1");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipalsUserPatternsDefaultBaseDn() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GUIDKEY, "sAMAccountName");
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=mycompany,dc=com");
        List<String> expected = Arrays.asList("sAMAccountName=user1,dc=mycompany,dc=com");
        List actual = LdapUtils.createCandidatePrincipals((HiveConf)conf, (String)"user1");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipals() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=mycompany,dc=com");
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "cn=%s,ou=CORP1,dc=mycompany,dc=com:cn=%s,ou=CORP2,dc=mycompany,dc=com");
        List<String> expected = Arrays.asList("cn=user1,ou=CORP1,dc=mycompany,dc=com", "cn=user1,ou=CORP2,dc=mycompany,dc=com");
        List actual = LdapUtils.createCandidatePrincipals((HiveConf)conf, (String)"user1");
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExtractFirstRdn() {
        String dn = "cn=user1,ou=CORP1,dc=mycompany,dc=com";
        String expected = "cn=user1";
        String actual = LdapUtils.extractFirstRdn((String)dn);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testExtractBaseDn() {
        String dn = "cn=user1,ou=CORP1,dc=mycompany,dc=com";
        String expected = "ou=CORP1,dc=mycompany,dc=com";
        String actual = LdapUtils.extractBaseDn((String)dn);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testExtractBaseDnNegative() {
        String dn = "cn=user1";
        Assert.assertNull((Object)LdapUtils.extractBaseDn((String)dn));
    }
}

