/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatAuthUtil;

public class HCatSemanticAnalyzerBase
extends AbstractSemanticAnalyzerHook {
    private HiveAuthorizationProvider authProvider;

    public HiveAuthorizationProvider getAuthProvider() {
        if (this.authProvider == null) {
            this.authProvider = SessionState.get().getAuthorizer();
        }
        return this.authProvider;
    }

    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        super.postAnalyze(context, rootTasks);
        this.authorizeDDL(context, rootTasks);
    }

    protected void authorizeDDL(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        if (!HCatAuthUtil.isAuthorizationEnabled(context.getConf())) {
            return;
        }
        try {
            Hive hive = context.getHive();
            for (Task<? extends Serializable> task : rootTasks) {
                DDLWork work;
                if (!(task.getWork() instanceof DDLWork) || (work = (DDLWork)task.getWork()) == null) continue;
                this.authorizeDDLWork(context, hive, work);
            }
        }
        catch (SemanticException ex) {
            throw ex;
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SemanticException((Throwable)ex);
        }
    }

    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext context, Hive hive, DDLWork work) throws HiveException {
    }

    protected void authorize(Privilege[] inputPrivs, Privilege[] outputPrivs) throws AuthorizationException, SemanticException {
        try {
            this.getAuthProvider().authorizeDbLevelOperations(inputPrivs, outputPrivs, null, null);
        }
        catch (HiveException ex) {
            throw new SemanticException((Throwable)ex);
        }
    }

    protected void authorize(Database db, Privilege priv) throws AuthorizationException, SemanticException {
        try {
            this.getAuthProvider().authorize(db, null, new Privilege[]{priv});
        }
        catch (HiveException ex) {
            throw new SemanticException((Throwable)ex);
        }
    }

    protected void authorizeTable(Hive hive, String tableName, Privilege priv) throws AuthorizationException, HiveException {
        Table table;
        try {
            table = hive.getTable(tableName);
        }
        catch (InvalidTableException ite) {
            return;
        }
        this.authorize(table, priv);
    }

    protected void authorize(Table table, Privilege priv) throws AuthorizationException, SemanticException {
        try {
            this.getAuthProvider().authorize(table, new Privilege[]{priv}, null);
        }
        catch (HiveException ex) {
            throw new SemanticException((Throwable)ex);
        }
    }

    protected void authorize(Partition part, Privilege priv) throws AuthorizationException, SemanticException {
        try {
            this.getAuthProvider().authorize(part, new Privilege[]{priv}, null);
        }
        catch (HiveException ex) {
            throw new SemanticException((Throwable)ex);
        }
    }
}

