/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.JsonString;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.util.Fields;
import org.ojai.util.impl.MutableFieldSegment;
import org.ojai.util.impl.ProjectionTree;

@API.Public
public abstract class BaseFieldProjector
implements JsonString {
    private static final FieldSegment DOCUMENT_ROOT = new FieldSegment.NameSegment("$$document", null, false);
    protected final ProjectionTree rootSegment;
    protected ProjectionTree currentSegment;
    protected ProjectionTree lastSegment;
    protected MutableFieldSegment readerFieldSegment;
    protected int level;
    protected boolean includeField;
    protected boolean includeAllChildren;

    protected BaseFieldProjector(String ... includedPaths) {
        this(Fields.toFieldPathArray((String[])Preconditions.checkNotNull((Object)includedPaths)));
    }

    protected BaseFieldProjector(FieldPath ... includedPaths) {
        this(Arrays.asList((Object[])Preconditions.checkNotNull((Object)includedPaths)));
    }

    protected BaseFieldProjector(@API.NonNullable Collection<FieldPath> includedPaths) {
        this.rootSegment = new ProjectionTree(DOCUMENT_ROOT, null);
        for (FieldPath includedPath : (Collection)Preconditions.checkNotNull(includedPaths)) {
            this.rootSegment.addOrGetChild(includedPath.getRootSegment());
        }
        this.finishConstruction();
    }

    public abstract BaseFieldProjector cloneWithSharedProjectionTree();

    protected BaseFieldProjector(ProjectionTree rootSegment) {
        this.rootSegment = rootSegment;
        this.finishConstruction();
    }

    private void finishConstruction() {
        if (this.rootSegment == null) {
            throw new AssertionError((Object)"`rootSegment` needs to be set before calling this method");
        }
        this.level = 0;
        this.currentSegment = this.rootSegment;
        this.lastSegment = this.rootSegment;
        this.includeField = false;
        this.includeAllChildren = false;
        this.readerFieldSegment = new MutableFieldSegment();
    }

    protected boolean shouldEmitEvent() {
        return this.includeField || this.includeAllChildren;
    }

    protected void moveTo(DocumentReader.EventType event) {
        throw new UnsupportedOperationException();
    }

    protected void moveTo(MutableFieldSegment keySegment, DocumentReader.EventType event) {
        throw new UnsupportedOperationException();
    }

    public boolean isDone() {
        return this.currentSegment == null;
    }

    protected BaseFieldProjector reset(DocumentReader reader) {
        throw new UnsupportedOperationException();
    }

    public BaseFieldProjector reset() {
        throw new UnsupportedOperationException();
    }

    public boolean done() {
        return this.currentSegment == null;
    }

    public String toString() {
        return this.asJsonString();
    }

    @Override
    public String asJsonString() {
        return this.rootSegment.toString();
    }

    @Override
    public String asJsonString(JsonOptions options) {
        return this.asJsonString();
    }
}

