/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.joda.base;

import java.io.Serializable;
import org.ojai.joda.Chronology;
import org.ojai.joda.DateTimeUtils;
import org.ojai.joda.MutableInterval;
import org.ojai.joda.ReadWritableInterval;
import org.ojai.joda.ReadableDuration;
import org.ojai.joda.ReadableInstant;
import org.ojai.joda.ReadableInterval;
import org.ojai.joda.ReadablePeriod;
import org.ojai.joda.base.AbstractInterval;
import org.ojai.joda.chrono.ISOChronology;
import org.ojai.joda.convert.ConverterManager;
import org.ojai.joda.convert.IntervalConverter;
import org.ojai.joda.field.FieldUtils;

public abstract class BaseInterval
extends AbstractInterval
implements ReadableInterval,
Serializable {
    private static final long serialVersionUID = 576586928732749278L;
    private volatile Chronology iChronology;
    private volatile long iStartMillis;
    private volatile long iEndMillis;

    protected BaseInterval(long l, long l2, Chronology chronology) {
        this.iChronology = DateTimeUtils.getChronology(chronology);
        this.checkInterval(l, l2);
        this.iStartMillis = l;
        this.iEndMillis = l2;
    }

    protected BaseInterval(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        if (readableInstant == null && readableInstant2 == null) {
            this.iStartMillis = this.iEndMillis = DateTimeUtils.currentTimeMillis();
            this.iChronology = ISOChronology.getInstance();
        } else {
            this.iChronology = DateTimeUtils.getInstantChronology(readableInstant);
            this.iStartMillis = DateTimeUtils.getInstantMillis(readableInstant);
            this.iEndMillis = DateTimeUtils.getInstantMillis(readableInstant2);
            this.checkInterval(this.iStartMillis, this.iEndMillis);
        }
    }

    protected BaseInterval(ReadableInstant readableInstant, ReadableDuration readableDuration) {
        this.iChronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.iStartMillis = DateTimeUtils.getInstantMillis(readableInstant);
        long l = DateTimeUtils.getDurationMillis(readableDuration);
        this.iEndMillis = FieldUtils.safeAdd(this.iStartMillis, l);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadableDuration readableDuration, ReadableInstant readableInstant) {
        this.iChronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.iEndMillis = DateTimeUtils.getInstantMillis(readableInstant);
        long l = DateTimeUtils.getDurationMillis(readableDuration);
        this.iStartMillis = FieldUtils.safeAdd(this.iEndMillis, -l);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadableInstant readableInstant, ReadablePeriod readablePeriod) {
        Chronology chronology;
        this.iChronology = chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.iStartMillis = DateTimeUtils.getInstantMillis(readableInstant);
        this.iEndMillis = readablePeriod == null ? this.iStartMillis : chronology.add(readablePeriod, this.iStartMillis, 1);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadablePeriod readablePeriod, ReadableInstant readableInstant) {
        Chronology chronology;
        this.iChronology = chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.iEndMillis = DateTimeUtils.getInstantMillis(readableInstant);
        this.iStartMillis = readablePeriod == null ? this.iEndMillis : chronology.add(readablePeriod, this.iEndMillis, -1);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(Object object, Chronology chronology) {
        IntervalConverter intervalConverter = ConverterManager.getInstance().getIntervalConverter(object);
        if (intervalConverter.isReadableInterval(object, chronology)) {
            ReadableInterval readableInterval = (ReadableInterval)object;
            this.iChronology = chronology != null ? chronology : readableInterval.getChronology();
            this.iStartMillis = readableInterval.getStartMillis();
            this.iEndMillis = readableInterval.getEndMillis();
        } else if (this instanceof ReadWritableInterval) {
            intervalConverter.setInto((ReadWritableInterval)((Object)this), object, chronology);
        } else {
            MutableInterval mutableInterval = new MutableInterval();
            intervalConverter.setInto(mutableInterval, object, chronology);
            this.iChronology = mutableInterval.getChronology();
            this.iStartMillis = mutableInterval.getStartMillis();
            this.iEndMillis = mutableInterval.getEndMillis();
        }
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    public long getStartMillis() {
        return this.iStartMillis;
    }

    public long getEndMillis() {
        return this.iEndMillis;
    }

    protected void setInterval(long l, long l2, Chronology chronology) {
        this.checkInterval(l, l2);
        this.iStartMillis = l;
        this.iEndMillis = l2;
        this.iChronology = DateTimeUtils.getChronology(chronology);
    }
}

