/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.TableType;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AcidTableSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AcidTableSerializer.class);
    private static final String PROLOG_V1 = "AcidTableV1:";

    public static String encode(AcidTable table) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (FilterOutputStream data = null;){
            data = new DataOutputStream(bytes);
            ((DataOutputStream)data).writeUTF(table.getDatabaseName());
            ((DataOutputStream)data).writeUTF(table.getTableName());
            ((DataOutputStream)data).writeBoolean(table.createPartitions());
            if (table.getWriteId() <= 0L) {
                LOG.warn("Write ID <= 0. The recipient is probably expecting a table write ID.");
            }
            ((DataOutputStream)data).writeLong(table.getWriteId());
            ((DataOutputStream)data).writeByte(table.getTableType().getId());
            Table metaTable = table.getTable();
            if (metaTable != null) {
                byte[] thrift = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory()).serialize((TBase)metaTable);
                ((DataOutputStream)data).writeInt(thrift.length);
                data.write(thrift);
            } else {
                LOG.warn("Meta store table is null. The recipient is probably expecting an instance.");
                ((DataOutputStream)data).writeInt(0);
            }
        }
        return PROLOG_V1 + new String(Base64.encodeBase64((byte[])bytes.toByteArray()), Charset.forName("UTF-8"));
    }

    public static AcidTable decode(String encoded) throws IOException {
        AcidTable table;
        block8: {
            if (!encoded.startsWith(PROLOG_V1)) {
                throw new IllegalStateException("Unsupported version.");
            }
            encoded = encoded.substring(PROLOG_V1.length());
            byte[] decoded = Base64.decodeBase64((String)encoded);
            table = null;
            try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(decoded));){
                String databaseName = in.readUTF();
                String tableName = in.readUTF();
                boolean createPartitions = in.readBoolean();
                long writeId = in.readLong();
                TableType tableType = TableType.valueOf(in.readByte());
                int thriftLength = in.readInt();
                table = new AcidTable(databaseName, tableName, createPartitions, tableType);
                table.setWriteId(writeId);
                Table metaTable = null;
                if (thriftLength <= 0) break block8;
                metaTable = new Table();
                try {
                    byte[] thriftEncoded = new byte[thriftLength];
                    in.readFully(thriftEncoded, 0, thriftLength);
                    new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory()).deserialize((TBase)metaTable, thriftEncoded);
                    table.setTable(metaTable);
                }
                catch (TException e) {
                    throw new IOException("Error deserializing meta store table.", e);
                }
            }
        }
        return table;
    }
}

