/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.exceptions;

import com.opencsv.exceptions.CsvRuntimeException;
import java.lang.reflect.Field;

public class CsvBeanIntrospectionException
extends CsvRuntimeException {
    private final Object bean;
    private final Field field;

    public CsvBeanIntrospectionException() {
        this.bean = null;
        this.field = null;
    }

    public CsvBeanIntrospectionException(String message) {
        super(message);
        this.bean = null;
        this.field = null;
    }

    public CsvBeanIntrospectionException(Object bean, Field field) {
        this.bean = bean;
        this.field = field;
    }

    public CsvBeanIntrospectionException(Object bean, Field field, String message) {
        super(message);
        this.bean = bean;
        this.field = field;
    }

    @Override
    public String getMessage() {
        String supermessage = super.getMessage();
        if (supermessage == null && this.getBean() != null && this.getField() != null) {
            return String.format("An introspection error was thrown while attempting to manipulate property %s of bean %s.", this.getField().getName(), this.getBean().getClass().getCanonicalName());
        }
        return supermessage;
    }

    public Object getBean() {
        return this.bean;
    }

    public Field getField() {
        return this.field;
    }
}

