/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import java.io.PrintStream;
import org.apache.orc.TypeDescription;
import org.apache.orc.tools.json.HiveType;
import org.apache.orc.tools.json.UnionType;

class ListType
extends HiveType {
    HiveType elementType;

    public ListType() {
        super(HiveType.Kind.LIST);
    }

    public ListType(HiveType child) {
        super(HiveType.Kind.LIST);
        this.elementType = child;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("list<");
        buf.append(this.elementType.toString());
        buf.append(">");
        return buf.toString();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.elementType.equals(((ListType)other).elementType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 3 + this.elementType.hashCode();
    }

    @Override
    public boolean subsumes(HiveType other) {
        return other.kind == HiveType.Kind.NULL || other.kind == HiveType.Kind.LIST;
    }

    @Override
    public void merge(HiveType other) {
        if (other instanceof ListType) {
            ListType otherList = (ListType)other;
            if (this.elementType.subsumes(otherList.elementType)) {
                this.elementType.merge(otherList.elementType);
            } else if (otherList.elementType.subsumes(this.elementType)) {
                otherList.elementType.merge(this.elementType);
                this.elementType = otherList.elementType;
            } else {
                this.elementType = new UnionType(this.elementType, otherList.elementType);
            }
        }
    }

    @Override
    public void printFlat(PrintStream out, String prefix) {
        this.elementType.printFlat(out, prefix + "._list");
    }

    @Override
    public TypeDescription getSchema() {
        return TypeDescription.createList((TypeDescription)this.elementType.getSchema());
    }
}

