/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class SqlDateStringConverter
implements TypeConverter<Date, String> {
    private static final long serialVersionUID = 2261633191458773325L;

    @Override
    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Date.valueOf(str);
        }
        catch (IllegalArgumentException iae) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Date.class.getName()), iae);
        }
    }

    @Override
    public String toDatastoreType(Date date) {
        return date != null ? date.toString() : null;
    }
}

