/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.llap.daemon.impl;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;

@InterfaceAudience.Private
public class LlapConstants {
  public static final String LOG4j2_PROPERTIES_FILE = "llap-daemon-log4j2.properties";
  public static final String LLAP_HADOOP_METRICS2_PROPERTIES_FILE = "hadoop-metrics2-llapdaemon.properties";
  public static final String HADOOP_METRICS2_PROPERTIES_FILE = "hadoop-metrics2.properties";

  // Note: Do not change without changing the corresponding reference in llap-daemon-log4j2.properties
  public static final String LLAP_LOG4j2_PURGE_POLICY_NAME_DAG_ROUTING =
      "llapLogPurgerDagRouting";
  // Note: Do not change without changing the corresponding reference in llap-daemon-log4j2.properties
  public static final String LLAP_LOG4j2_PURGE_POLICY_NAME_QUERY_ROUTING =
      "llapLogPurgerQueryRouting";

}
