/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.metrics.Monitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;

public class MonitorsConfig {
    public static final String METRIC_DIMENSION_PREFIX = "druid.metrics.emitter.dimension.";
    @JsonProperty(value="monitors")
    @NotNull
    private List<Class<? extends Monitor>> monitors = Lists.newArrayList();

    public List<Class<? extends Monitor>> getMonitors() {
        return this.monitors;
    }

    public String toString() {
        return "MonitorsConfig{monitors=" + this.monitors + '}';
    }

    public static Map<String, String[]> mapOfDatasourceAndTaskID(String datasource, String taskId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (datasource != null) {
            builder.put((Object)"dataSource", (Object)new String[]{datasource});
        }
        if (taskId != null) {
            builder.put((Object)"id", (Object)new String[]{taskId});
        }
        return builder.build();
    }

    public static Map<String, String[]> extractDimensions(Properties props, List<String> dimensions) {
        HashMap<String, String[]> dimensionsMap = new HashMap<String, String[]>();
        for (String property : props.stringPropertyNames()) {
            String dimension;
            if (!property.startsWith(METRIC_DIMENSION_PREFIX) || !dimensions.contains(dimension = property.substring(METRIC_DIMENSION_PREFIX.length()))) continue;
            dimensionsMap.put(dimension, new String[]{props.getProperty(property)});
        }
        return dimensionsMap;
    }
}

