/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.google.inject.Inject;
import com.metamx.common.collect.CountingMap;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import io.druid.client.DruidServerConfig;
import io.druid.server.coordination.ServerManager;
import io.druid.server.coordination.ZkCoordinator;
import io.druid.timeline.DataSegment;
import java.util.Map;

public class HistoricalMetricsMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final ServerManager serverManager;
    private final ZkCoordinator zkCoordinator;

    @Inject
    public HistoricalMetricsMonitor(DruidServerConfig serverConfig, ServerManager serverManager, ZkCoordinator zkCoordinator) {
        this.serverConfig = serverConfig;
        this.serverManager = serverManager;
        this.zkCoordinator = zkCoordinator;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        String dataSource;
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/max", (Number)this.serverConfig.getMaxSize()));
        CountingMap pendingDeleteSizes = new CountingMap();
        for (DataSegment dataSegment : this.zkCoordinator.getPendingDeleteSnapshot()) {
            pendingDeleteSizes.add((Object)dataSegment.getDataSource(), Long.valueOf(dataSegment.getSize()));
        }
        for (Map.Entry entry : pendingDeleteSizes.entrySet()) {
            dataSource = (String)entry.getKey();
            long pendingDeleteSize = (Long)entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority())).build("segment/pendingDelete", (Number)pendingDeleteSize));
        }
        for (Map.Entry entry : this.serverManager.getDataSourceSizes().entrySet()) {
            dataSource = (String)entry.getKey();
            long used = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/used", (Number)used));
            double usedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)used / (double)this.serverConfig.getMaxSize();
            emitter.emit(builder.build("segment/usedPercent", (Number)usedPercent));
        }
        for (Map.Entry entry : this.serverManager.getDataSourceCounts().entrySet()) {
            dataSource = (String)entry.getKey();
            long count = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/count", (Number)count));
        }
        return true;
    }
}

