/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.server.security.Access;
import io.druid.server.security.Action;
import io.druid.server.security.AuthorizationInfo;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

public class InventoryViewUtils {
    public static Set<DruidDataSource> getDataSources(InventoryView serverInventoryView) {
        TreeSet dataSources = Sets.newTreeSet((Comparator)new Comparator<DruidDataSource>(){

            @Override
            public int compare(DruidDataSource druidDataSource, DruidDataSource druidDataSource1) {
                return druidDataSource.getName().compareTo(druidDataSource1.getName());
            }
        });
        dataSources.addAll(Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(serverInventoryView.getInventory(), (Function)new Function<DruidServer, Iterable<DruidDataSource>>(){

            public Iterable<DruidDataSource> apply(DruidServer input) {
                return input.getDataSources();
            }
        }))));
        return dataSources;
    }

    public static Set<DruidDataSource> getSecuredDataSources(InventoryView inventoryView, final AuthorizationInfo authorizationInfo) {
        if (authorizationInfo == null) {
            throw new ISE("Invalid to call a secured method with null AuthorizationInfo!!", new Object[0]);
        }
        final HashMap resourceAccessMap = new HashMap();
        return ImmutableSet.copyOf((Iterable)Iterables.filter(InventoryViewUtils.getDataSources(inventoryView), (Predicate)new Predicate<DruidDataSource>(){

            public boolean apply(DruidDataSource input) {
                Action action;
                Resource resource = new Resource(input.getName(), ResourceType.DATASOURCE);
                Pair key = new Pair((Object)resource, (Object)(action = Action.READ));
                if (resourceAccessMap.containsKey(key)) {
                    return ((Access)resourceAccessMap.get(key)).isAllowed();
                }
                Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)((Object)key.rhs));
                resourceAccessMap.put(key, access);
                return access.isAllowed();
            }
        }));
    }
}

