/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import com.metamx.common.guava.Comparators;
import io.druid.client.DruidDataSource;
import io.druid.client.InventoryView;
import io.druid.server.http.InventoryViewUtils;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationInfo;
import io.druid.timeline.DataSegment;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/intervals")
public class IntervalsResource {
    private final InventoryView serverInventoryView;
    private final AuthConfig authConfig;

    @Inject
    public IntervalsResource(InventoryView serverInventoryView, AuthConfig authConfig) {
        this.serverInventoryView = serverInventoryView;
        this.authConfig = authConfig;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIntervals(@Context HttpServletRequest req) {
        Comparator comparator = Comparators.inverse((Comparator)Comparators.intervalsByStartThenEnd());
        Set<DruidDataSource> datasources = this.authConfig.isEnabled() ? InventoryViewUtils.getSecuredDataSources(this.serverInventoryView, (AuthorizationInfo)req.getAttribute("Druid-Auth-Token")) : InventoryViewUtils.getDataSources(this.serverInventoryView);
        TreeMap retVal = Maps.newTreeMap((Comparator)comparator);
        for (DruidDataSource dataSource : datasources) {
            for (DataSegment dataSegment : dataSource.getSegments()) {
                Map interval = (Map)retVal.get(dataSegment.getInterval());
                if (interval == null) {
                    HashMap tmp = Maps.newHashMap();
                    retVal.put(dataSegment.getInterval(), tmp);
                }
                this.setProperties(retVal, dataSource, dataSegment);
            }
        }
        return Response.ok((Object)retVal).build();
    }

    @GET
    @Path(value="/{interval}")
    @Produces(value={"application/json"})
    public Response getSpecificIntervals(@PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full, @Context HttpServletRequest req) {
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        Set<DruidDataSource> datasources = this.authConfig.isEnabled() ? InventoryViewUtils.getSecuredDataSources(this.serverInventoryView, (AuthorizationInfo)req.getAttribute("Druid-Auth-Token")) : InventoryViewUtils.getDataSources(this.serverInventoryView);
        Comparator comparator = Comparators.inverse((Comparator)Comparators.intervalsByStartThenEnd());
        if (full != null) {
            TreeMap retVal = Maps.newTreeMap((Comparator)comparator);
            for (DruidDataSource dataSource : datasources) {
                for (DataSegment dataSegment : dataSource.getSegments()) {
                    if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                    Map dataSourceInterval = (Map)retVal.get(dataSegment.getInterval());
                    if (dataSourceInterval == null) {
                        HashMap tmp = Maps.newHashMap();
                        retVal.put(dataSegment.getInterval(), tmp);
                    }
                    this.setProperties(retVal, dataSource, dataSegment);
                }
            }
            return Response.ok((Object)retVal).build();
        }
        if (simple != null) {
            HashMap retVal = Maps.newHashMap();
            for (DruidDataSource dataSource : datasources) {
                for (DataSegment dataSegment : dataSource.getSegments()) {
                    if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                    Map properties = (Map)retVal.get(dataSegment.getInterval());
                    if (properties == null) {
                        properties = Maps.newHashMap();
                        properties.put("size", dataSegment.getSize());
                        properties.put("count", 1);
                        retVal.put(dataSegment.getInterval(), properties);
                        continue;
                    }
                    properties.put("size", MapUtils.getLong((Map)properties, (String)"size", (Long)0L) + dataSegment.getSize());
                    properties.put("count", MapUtils.getInt((Map)properties, (String)"count", (Integer)0) + 1);
                }
            }
            return Response.ok((Object)retVal).build();
        }
        HashMap retVal = Maps.newHashMap();
        for (DruidDataSource dataSource : datasources) {
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                retVal.put("size", MapUtils.getLong((Map)retVal, (String)"size", (Long)0L) + dataSegment.getSize());
                retVal.put("count", MapUtils.getInt((Map)retVal, (String)"count", (Integer)0) + 1);
            }
        }
        return Response.ok((Object)retVal).build();
    }

    private void setProperties(Map<Interval, Map<String, Map<String, Object>>> retVal, DruidDataSource dataSource, DataSegment dataSegment) {
        HashMap properties = retVal.get(dataSegment.getInterval()).get(dataSource.getName());
        if (properties == null) {
            properties = Maps.newHashMap();
            properties.put("size", dataSegment.getSize());
            properties.put("count", 1);
            retVal.get(dataSegment.getInterval()).put(dataSource.getName(), properties);
        } else {
            properties.put("size", MapUtils.getLong((Map)properties, (String)"size", (Long)0L) + dataSegment.getSize());
            properties.put("count", MapUtils.getInt((Map)properties, (String)"count", (Integer)0) + 1);
        }
    }
}

