/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.metamx.common.Granularity;
import com.metamx.common.ISE;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.guava.Sequence;
import com.metamx.emitter.EmittingLogger;
import io.druid.common.guava.ThreadRenamingCallable;
import io.druid.concurrent.Execs;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentNotWritableException;
import io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import io.druid.segment.realtime.plumber.Committers;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RejectionPolicy;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class AppenderatorPlumber
implements Plumber {
    private static final EmittingLogger log = new EmittingLogger(AppenderatorPlumber.class);
    private static final int WARN_DELAY = 1000;
    private final DataSchema schema;
    private final RealtimeTuningConfig config;
    private final RejectionPolicy rejectionPolicy;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final SegmentPublisher segmentPublisher;
    private final SegmentHandoffNotifier handoffNotifier;
    private final Object handoffCondition = new Object();
    private final Map<Long, SegmentIdentifier> segments = Maps.newConcurrentMap();
    private final Appenderator appenderator;
    private volatile boolean shuttingDown = false;
    private volatile boolean stopped = false;
    private volatile boolean cleanShutdown = true;
    private volatile ScheduledExecutorService scheduledExecutor = null;
    private volatile Supplier<Committer> lastCommitterSupplier = null;

    public AppenderatorPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics, DataSegmentAnnouncer segmentAnnouncer, SegmentPublisher segmentPublisher, SegmentHandoffNotifier handoffNotifier, Appenderator appenderator) {
        this.schema = schema;
        this.config = config;
        this.rejectionPolicy = config.getRejectionPolicyFactory().create(config.getWindowPeriod());
        this.metrics = metrics;
        this.segmentAnnouncer = segmentAnnouncer;
        this.segmentPublisher = segmentPublisher;
        this.handoffNotifier = handoffNotifier;
        this.appenderator = appenderator;
        log.info("Creating plumber using rejectionPolicy[%s]", new Object[]{this.getRejectionPolicy()});
    }

    public Map<Long, SegmentIdentifier> getSegmentsView() {
        return ImmutableMap.copyOf(this.segments);
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public RealtimeTuningConfig getConfig() {
        return this.config;
    }

    public RejectionPolicy getRejectionPolicy() {
        return this.rejectionPolicy;
    }

    @Override
    public Object startJob() {
        this.handoffNotifier.start();
        Object retVal = this.appenderator.startJob();
        this.initializeExecutors();
        this.startPersistThread();
        this.mergeAndPush();
        return retVal;
    }

    @Override
    public int add(InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException {
        SegmentIdentifier identifier = this.getSegmentIdentifier(row.getTimestampFromEpoch());
        if (identifier == null) {
            return -1;
        }
        try {
            int numRows = this.appenderator.add(identifier, row, committerSupplier);
            this.lastCommitterSupplier = committerSupplier;
            return numRows;
        }
        catch (SegmentNotWritableException e) {
            return -1;
        }
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        return new QueryRunner<T>(){

            public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
                return query.run((QuerySegmentWalker)AppenderatorPlumber.this.appenderator, responseContext);
            }
        };
    }

    @Override
    public void persist(Committer committer) {
        Stopwatch runExecStopwatch = Stopwatch.createStarted();
        this.appenderator.persistAll(committer);
        long startDelay = runExecStopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.metrics.incrementPersistBackPressureMillis(startDelay);
        if (startDelay > 1000L) {
            log.warn("Ingestion was throttled for [%,d] millis because persists were pending.", new Object[]{startDelay});
        }
        runExecStopwatch.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJob() {
        log.info("Shutting down...", new Object[0]);
        this.shuttingDown = true;
        List<SegmentIdentifier> pending = this.appenderator.getSegments();
        if (pending.isEmpty()) {
            log.info("No segments to hand off.", new Object[0]);
        } else {
            log.info("Pushing segments: %s", new Object[]{Joiner.on((String)", ").join(pending)});
        }
        try {
            if (this.lastCommitterSupplier != null) {
                this.mergeAndPush();
            }
            Object object = this.handoffCondition;
            synchronized (object) {
                while (!this.segments.isEmpty()) {
                    log.info("Waiting to hand off: %s", new Object[]{Joiner.on((String)", ").join(pending)});
                    this.handoffCondition.wait();
                    pending = this.appenderator.getSegments();
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.stopped = true;
            this.handoffNotifier.close();
            this.shutdownExecutors();
            this.appenderator.close();
        }
        if (!this.cleanShutdown) {
            throw new ISE("Exception occurred during persist and merge.", new Object[0]);
        }
    }

    private SegmentIdentifier getSegmentIdentifier(long timestamp) {
        if (!this.rejectionPolicy.accept(timestamp)) {
            return null;
        }
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        VersioningPolicy versioningPolicy = this.config.getVersioningPolicy();
        long truncatedTime = segmentGranularity.truncate(new DateTime(timestamp)).getMillis();
        SegmentIdentifier retVal = this.segments.get(truncatedTime);
        if (retVal == null) {
            Interval interval = new Interval((ReadableInstant)new DateTime(truncatedTime), (ReadableInstant)segmentGranularity.increment(new DateTime(truncatedTime)));
            retVal = new SegmentIdentifier(this.schema.getDataSource(), interval, versioningPolicy.getVersion(interval), this.config.getShardSpec());
            this.addSegment(retVal);
        }
        return retVal;
    }

    protected void initializeExecutors() {
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Execs.scheduledSingleThreaded((String)"plumber_scheduled_%d");
        }
    }

    protected void shutdownExecutors() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    private void addSegment(SegmentIdentifier identifier) {
        this.segments.put(identifier.getInterval().getStartMillis(), identifier);
        try {
            this.segmentAnnouncer.announceSegment(new DataSegment(identifier.getDataSource(), identifier.getInterval(), identifier.getVersion(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), identifier.getShardSpec(), null, 0L));
        }
        catch (IOException e) {
            log.makeAlert((Throwable)e, "Failed to announce new segment[%s]", new Object[]{identifier.getDataSource()}).addData("interval", (Object)identifier.getInterval()).emit();
        }
    }

    public void dropSegment(final SegmentIdentifier identifier) {
        log.info("Dropping segment: %s", new Object[]{identifier});
        this.segments.remove(identifier.getInterval().getStartMillis());
        Futures.addCallback(this.appenderator.drop(identifier), (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                log.info("Dropped segment: %s", new Object[]{identifier});
            }

            public void onFailure(Throwable e) {
                log.warn(e, "Failed to drop segment: %s", new Object[]{identifier});
            }
        });
    }

    private void startPersistThread() {
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        Period windowPeriod = this.config.getWindowPeriod();
        DateTime truncatedNow = segmentGranularity.truncate(new DateTime());
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        log.info("Expect to run at [%s]", new Object[]{new DateTime().plus((ReadableDuration)new Duration(System.currentTimeMillis(), segmentGranularity.increment(truncatedNow).getMillis() + windowMillis))});
        ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.scheduledExecutor, (Duration)new Duration(System.currentTimeMillis(), segmentGranularity.increment(truncatedNow).getMillis() + windowMillis), (Duration)new Duration((ReadableInstant)truncatedNow, (ReadableInstant)segmentGranularity.increment(truncatedNow)), (Callable)new ThreadRenamingCallable<ScheduledExecutors.Signal>(String.format("%s-overseer-%d", this.schema.getDataSource(), this.config.getShardSpec().getPartitionNum())){

            public ScheduledExecutors.Signal doCall() {
                if (AppenderatorPlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                AppenderatorPlumber.this.mergeAndPush();
                if (AppenderatorPlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        });
    }

    private void mergeAndPush() {
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        Period windowPeriod = this.config.getWindowPeriod();
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        log.info("Starting merge and push.", new Object[0]);
        DateTime minTimestampAsDate = segmentGranularity.truncate(new DateTime(Math.max(windowMillis, this.rejectionPolicy.getCurrMaxTime().getMillis()) - windowMillis));
        long minTimestamp = minTimestampAsDate.getMillis();
        List<SegmentIdentifier> appenderatorSegments = this.appenderator.getSegments();
        final ArrayList segmentsToPush = Lists.newArrayList();
        if (this.shuttingDown) {
            log.info("Found [%,d] segments. Attempting to hand off all of them.", new Object[]{appenderatorSegments.size()});
            segmentsToPush.addAll(appenderatorSegments);
        } else {
            log.info("Found [%,d] segments. Attempting to hand off segments that start before [%s].", new Object[]{appenderatorSegments.size(), minTimestampAsDate});
            for (SegmentIdentifier segment : appenderatorSegments) {
                Long intervalStart = segment.getInterval().getStartMillis();
                if (intervalStart < minTimestamp) {
                    log.info("Adding entry [%s] for merge and push.", new Object[]{segment});
                    segmentsToPush.add(segment);
                    continue;
                }
                log.info("Skipping persist and merge for entry [%s] : Start time [%s] >= [%s] min timestamp required in this run. Segment will be picked up in a future run.", new Object[]{segment, new DateTime((Object)intervalStart), minTimestampAsDate});
            }
        }
        log.info("Found [%,d] segments to persist and merge", new Object[]{segmentsToPush.size()});
        Function<Throwable, Void> errorHandler = new Function<Throwable, Void>(){

            public Void apply(Throwable throwable) {
                List segmentIdentifierStrings = Lists.transform((List)segmentsToPush, (Function)new Function<SegmentIdentifier, String>(){

                    public String apply(SegmentIdentifier input) {
                        return input.getIdentifierAsString();
                    }
                });
                log.makeAlert(throwable, "Failed to publish merged indexes[%s]", new Object[]{AppenderatorPlumber.this.schema.getDataSource()}).addData("segments", (Object)segmentIdentifierStrings).emit();
                if (AppenderatorPlumber.this.shuttingDown) {
                    AppenderatorPlumber.this.cleanShutdown = false;
                    for (SegmentIdentifier identifier : segmentsToPush) {
                        AppenderatorPlumber.this.dropSegment(identifier);
                    }
                }
                return null;
            }
        };
        Futures.addCallback(this.appenderator.push(segmentsToPush, Committers.nil()), (FutureCallback)new FutureCallback<SegmentsAndMetadata>((Function)errorHandler, (List)segmentsToPush){
            final /* synthetic */ Function val$errorHandler;
            final /* synthetic */ List val$segmentsToPush;
            {
                this.val$errorHandler = function;
                this.val$segmentsToPush = list;
            }

            public void onSuccess(SegmentsAndMetadata result) {
                for (DataSegment pushedSegment : result.getSegments()) {
                    try {
                        AppenderatorPlumber.this.segmentPublisher.publishSegment(pushedSegment);
                    }
                    catch (Exception e) {
                        this.val$errorHandler.apply((Object)e);
                    }
                }
                log.info("Published [%,d] sinks.", new Object[]{this.val$segmentsToPush.size()});
            }

            public void onFailure(Throwable e) {
                log.warn(e, "Failed to push [%,d] segments.", new Object[]{this.val$segmentsToPush.size()});
                this.val$errorHandler.apply((Object)e);
            }
        });
    }
}

