/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator;

import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class CuratorUtils {
    public static final int DEFAULT_MAX_ZNODE_BYTES = 524288;
    private static final Logger log = new Logger(CuratorUtils.class);

    public static void createIfNotExists(CuratorFramework curatorFramework, String path, CreateMode mode, byte[] rawBytes, int maxZnodeBytes) throws Exception {
        CuratorUtils.verifySize(path, rawBytes, maxZnodeBytes);
        if (curatorFramework.checkExists().forPath(path) == null) {
            try {
                ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, rawBytes);
            }
            catch (KeeperException.NodeExistsException e) {
                log.info("Skipping create path[%s], since it already exists.", new Object[]{path});
            }
        }
    }

    public static void createOrSet(CuratorFramework curatorFramework, String path, CreateMode mode, byte[] rawBytes, int maxZnodeBytes) throws Exception {
        CuratorUtils.verifySize(path, rawBytes, maxZnodeBytes);
        boolean created = false;
        if (curatorFramework.checkExists().forPath(path) == null) {
            try {
                ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, rawBytes);
                created = true;
            }
            catch (KeeperException.NodeExistsException e) {
                log.debug("Path [%s] created while we were running, will setData instead.", new Object[]{path});
            }
        }
        if (!created) {
            try {
                curatorFramework.setData().forPath(path, rawBytes);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("Someone deleted path[%s] while we were trying to set it. Leaving it deleted.", new Object[]{path});
            }
        }
    }

    private static void verifySize(String path, byte[] rawBytes, int maxZnodeBytes) {
        if (rawBytes.length > maxZnodeBytes) {
            throw new IAE("Length of raw bytes for znode[%s] too large[%,d > %,d]", new Object[]{path, rawBytes.length, maxZnodeBytes});
        }
    }
}

