/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.guava;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;

public class GuavaUtils {
    public static Function<String, String> formatFunction(final String formatString) {
        return new Function<String, String>(){

            public String apply(@Nullable String input) {
                return String.format(formatString, input);
            }
        };
    }

    public static InputSupplier<BufferedReader> joinFiles(File ... files) {
        return GuavaUtils.joinFiles(Arrays.asList(files));
    }

    public static InputSupplier<BufferedReader> joinFiles(final List<File> files) {
        return new InputSupplier<BufferedReader>(){

            public BufferedReader getInput() throws IOException {
                return new BufferedReader((Reader)CharStreams.join((Iterable)Iterables.transform((Iterable)files, (Function)new Function<File, InputSupplier<InputStreamReader>>(){

                    public InputSupplier<InputStreamReader> apply(final File input) {
                        return new InputSupplier<InputStreamReader>(){

                            public InputStreamReader getInput() throws IOException {
                                InputStream baseStream = new FileInputStream(input);
                                if (input.getName().endsWith(".gz")) {
                                    baseStream = new GZIPInputStream(baseStream);
                                }
                                return new InputStreamReader(baseStream, Charsets.UTF_8);
                            }
                        };
                    }
                })).getInput());
            }
        };
    }
}

