/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.metamx.common.logger.Logger;
import io.druid.collections.ReferenceCountingResourceHolder;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingPool<T> {
    private static final Logger log = new Logger(BlockingPool.class);
    private final BlockingQueue<T> objects;

    public BlockingPool(Supplier<T> generator, int limit) {
        this.objects = limit > 0 ? new ArrayBlockingQueue(limit) : null;
        for (int i = 0; i < limit; ++i) {
            this.objects.add(generator.get());
        }
    }

    public ReferenceCountingResourceHolder<T> take(long timeout) throws InterruptedException {
        Preconditions.checkState((this.objects != null ? 1 : 0) != 0, (Object)"Pool was initialized with limit = 0, there are no objects to take.");
        final T theObject = timeout >= 0L ? this.objects.poll(timeout, TimeUnit.MILLISECONDS) : this.objects.take();
        return theObject == null ? null : new ReferenceCountingResourceHolder<T>(theObject, new Closeable(){

            @Override
            public void close() throws IOException {
                if (!BlockingPool.this.objects.offer(theObject)) {
                    log.error("WTF?! Queue offer failed, uh oh...", new Object[0]);
                }
            }
        });
    }
}

