/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.Yielders;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.common.guava.YieldingSequenceBase;
import java.io.IOException;
import java.util.PriorityQueue;

public class MergeSequence<T>
extends YieldingSequenceBase<T> {
    private final Ordering<T> ordering;
    private final Sequence<Sequence<T>> baseSequences;

    public MergeSequence(Ordering<T> ordering, Sequence<Sequence<T>> baseSequences) {
        this.ordering = ordering;
        this.baseSequences = baseSequences;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        PriorityQueue<Yielder<T>> pQueue = new PriorityQueue<Yielder<T>>(32, this.ordering.onResultOf(new Function<Yielder<T>, T>(){

            public T apply(Yielder<T> input) {
                return input.get();
            }
        }));
        pQueue = this.baseSequences.accumulate(pQueue, new Accumulator<PriorityQueue<Yielder<T>>, Sequence<T>>(){

            @Override
            public PriorityQueue<Yielder<T>> accumulate(PriorityQueue<Yielder<T>> queue, Sequence<T> in) {
                Yielder<Object> yielder = in.toYielder(null, new YieldingAccumulator<T, T>(){

                    @Override
                    public T accumulate(T accumulated, T in) {
                        this.yield();
                        return in;
                    }
                });
                if (!yielder.isDone()) {
                    queue.add(yielder);
                } else {
                    try {
                        yielder.close();
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                return queue;
            }
        });
        return this.makeYielder(pQueue, initValue, accumulator);
    }

    private <OutType> Yielder<OutType> makeYielder(final PriorityQueue<Yielder<T>> pQueue, OutType initVal, final YieldingAccumulator<OutType, T> accumulator) {
        OutType retVal = initVal;
        while (!accumulator.yielded() && !pQueue.isEmpty()) {
            Yielder<Object> yielder = (Yielder<Object>)pQueue.remove();
            retVal = accumulator.accumulate(retVal, yielder.get());
            if ((yielder = yielder.next(null)).isDone()) {
                try {
                    yielder.close();
                    continue;
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            pQueue.add(yielder);
        }
        if (pQueue.isEmpty() && !accumulator.yielded()) {
            return Yielders.done(retVal, null);
        }
        final OutType yieldVal = retVal;
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yieldVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                return MergeSequence.this.makeYielder(pQueue, initValue, accumulator);
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                while (!pQueue.isEmpty()) {
                    ((Yielder)pQueue.remove()).close();
                }
            }
        };
    }
}

