/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    public static final WebSecurityConfig CONFIG = new WebSecurityConfig();
    private static final String UNSET_PROCESS_NAME = "<UNSET_PROCESS_NAME>";
    private String processName = "<UNSET_PROCESS_NAME>";
    private final String maprHome;
    private final String maprImpersonationEnabled = System.getenv("MAPR_IMPERSONATION_ENABLED");
    private final String maprClusterCfgLocation;
    private final String maprServerTicketName = "maprserverticket";

    private WebSecurityConfig() {
        String home = System.getProperty("mapr.home.dir");
        if (home == null && (home = System.getenv("MAPR_HOME")) == null) {
            home = SystemUtils.IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
        }
        this.maprHome = home;
        this.maprClusterCfgLocation = this.maprHome + "/conf/mapr-clusters.conf";
    }

    public String getProcessName() {
        if (this.processName == UNSET_PROCESS_NAME) {
            log.warn("A process name has not been set using com.mapr.security.web.Config.setProcessName()");
        }
        return this.processName;
    }

    WebSecurityConfig setProcessName(String processName) {
        Preconditions.checkNotNull((Object)processName);
        if (this.processName == UNSET_PROCESS_NAME) {
            log.info("Setting the current process name to '{}'", (Object)processName);
            this.processName = processName;
        } else if (this.processName != processName) {
            log.warn("Attempt to reset the process({}) name to '{}'", (Object)this.processName, (Object)processName);
        }
        return this;
    }

    public String getMaprHome() {
        return this.maprHome;
    }

    public String getMaprImpersonationEnabled() {
        return this.maprImpersonationEnabled;
    }

    public String getMaprClusterCfgLocation() {
        return this.maprClusterCfgLocation;
    }

    public String getMaprServerTicketName() {
        return this.maprServerTicketName;
    }
}

