/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.EmitterBuilder;
import com.metamx.emitter.core.LoggingEmitter;
import com.metamx.http.client.HttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Emitters {
    private static final Logger log = new Logger(Emitters.class);
    private static final String LOG_EMITTER_PROP = "com.metamx.emitter.logging";
    private static final String HTTP_EMITTER_PROP = "com.metamx.emitter.http";

    public static Emitter create(Properties props, HttpClient httpClient, Lifecycle lifecycle) {
        return Emitters.create(props, httpClient, new ObjectMapper(), lifecycle);
    }

    public static Emitter create(Properties props, HttpClient httpClient, ObjectMapper jsonMapper, Lifecycle lifecycle) {
        HashMap jsonified = Maps.newHashMap();
        if (props.getProperty(LOG_EMITTER_PROP) != null) {
            jsonified.put("logging", Emitters.makeLoggingMap(props));
        } else if (props.getProperty(HTTP_EMITTER_PROP) != null) {
            jsonified.put("http", Emitters.makeHttpMap(props));
        } else {
            throw new ISE("Unknown type of emitter. Please set [%s] or [%s]", new Object[]{LOG_EMITTER_PROP, HTTP_EMITTER_PROP});
        }
        return ((EmitterBuilder)jsonMapper.convertValue((Object)jsonified, EmitterBuilder.class)).build(jsonMapper, httpClient, lifecycle);
    }

    static Map<String, Object> makeHttpMap(Properties props) {
        HashMap httpMap = Maps.newHashMap();
        String urlProperty = "com.metamx.emitter.http.url";
        String baseUrl = props.getProperty("com.metamx.emitter.http.url");
        if (baseUrl == null) {
            throw new IAE("Property[%s] must be set", new Object[]{"com.metamx.emitter.http.url"});
        }
        httpMap.put("recipientBaseUrl", baseUrl);
        httpMap.put("flushMillis", Long.parseLong(props.getProperty("com.metamx.emitter.flushMillis", "60000")));
        httpMap.put("flushCount", Integer.parseInt(props.getProperty("com.metamx.emitter.flushCount", "300")));
        httpMap.put("flushTimeOut", Long.parseLong(props.getProperty("com.metamx.emitter.http.flushTimeOut", String.valueOf(Long.MAX_VALUE))));
        if (props.containsKey("com.metamx.emitter.http.basicAuthentication")) {
            httpMap.put("basicAuthentication", props.getProperty("com.metamx.emitter.http.basicAuthentication"));
        }
        if (props.containsKey("com.metamx.emitter.http.batchingStrategy")) {
            httpMap.put("batchingStrategy", props.getProperty("com.metamx.emitter.http.batchingStrategy").toUpperCase());
        }
        if (props.containsKey("com.metamx.emitter.http.maxBatchSize")) {
            httpMap.put("maxBatchSize", Integer.parseInt(props.getProperty("com.metamx.emitter.http.maxBatchSize")));
        }
        if (props.containsKey("com.metamx.emitter.http.maxBufferSize")) {
            httpMap.put("maxBufferSize", Long.parseLong(props.getProperty("com.metamx.emitter.http.maxBufferSize")));
        }
        return httpMap;
    }

    static Map<String, Object> makeLoggingMap(Properties props) {
        HashMap loggingMap = Maps.newHashMap();
        loggingMap.put("loggerClass", props.getProperty("com.metamx.emitter.logging.class", LoggingEmitter.class.getName()));
        loggingMap.put("logLevel", props.getProperty("com.metamx.emitter.logging.level", "debug"));
        return loggingMap;
    }
}

