/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyDecoder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.proto.Dbserver;
import com.mapr.utils.ByteReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowcolCodec {
    static Logger logger = LoggerFactory.getLogger(RowcolCodec.class);

    public static DBDocumentImpl getDBDocument(Document r) {
        if (r instanceof DBDocumentImpl) {
            return (DBDocumentImpl)r;
        }
        return (DBDocumentImpl)DBValueBuilderImpl.KeyValueBuilder.initFrom(r);
    }

    private static Map<Integer, ByteBuffer> getUpdatedCachedBufferMap(Map<FieldPath, Integer> newJsonPathMap, DBDocumentImpl origRec) {
        if (origRec.cachedBuffer == null) {
            return null;
        }
        Map<FieldPath, Integer> origJsonPathMap = origRec.cachedBuffer.jsonPathMap;
        Map<Integer, ByteBuffer> origCachedBufferMap = origRec.cachedBuffer.map;
        if (newJsonPathMap == null) {
            return origCachedBufferMap;
        }
        HashMap<Integer, Integer> fidMap = new HashMap<Integer, Integer>();
        boolean jsonPathMapChanged = false;
        for (Map.Entry<FieldPath, Integer> kv : origJsonPathMap.entrySet()) {
            Integer oldInt = kv.getValue();
            Integer newInt = newJsonPathMap.get(kv.getKey());
            if (newInt == null) {
                jsonPathMapChanged = true;
                continue;
            }
            if (oldInt.compareTo(newInt) != 0) {
                jsonPathMapChanged = true;
            }
            fidMap.put(oldInt, newInt);
        }
        if (!jsonPathMapChanged) {
            return origCachedBufferMap;
        }
        LinkedHashMap<Integer, ByteBuffer> newCachedBufferMap = new LinkedHashMap<Integer, ByteBuffer>();
        for (Map.Entry<Integer, ByteBuffer> kv : origCachedBufferMap.entrySet()) {
            Integer oldInt = kv.getKey();
            Integer newInt = (Integer)fidMap.get(oldInt);
            if (newInt == null) {
                return null;
            }
            ByteBuffer buf = kv.getValue();
            newCachedBufferMap.put(newInt, buf);
        }
        return newCachedBufferMap;
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap, boolean isBulkLoad, boolean useCached) {
        DBDocumentImpl rec = RowcolCodec.getDBDocument(document);
        if (useCached && rec.cachedBuffer != null) {
            SerializationContext ctx = new SerializationContext();
            Map<Integer, ByteBuffer> cachedBufferMap = RowcolCodec.getUpdatedCachedBufferMap(jsonPathMap, rec);
            if (cachedBufferMap != null) {
                return ctx.getSerializedBuffers(jsonPathMap, cachedBufferMap);
            }
        }
        if (rec.getNeedDOMStruct()) {
            rec.getDOMFromCachedBuffer();
        }
        return new SerializationContext().setFullRecordOp(true).setStoreRowTS(isBulkLoad).serializeFamilies(rec, jsonPathMap).getSerializedBuffers();
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap) {
        return RowcolCodec.encode(document, jsonPathMap, false, false);
    }

    public static ByteBuffer encode(Document document) {
        SerializedFamilyInfo[] familyInfo = RowcolCodec.encode(document, Constants.DEFAULT_FAMILY_MAP, false, false);
        assert (familyInfo.length == 1);
        return familyInfo[0].getByteBuffer();
    }

    public static void decodeInternalWithFieldPath(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean decodeTimestamp, boolean preserveDeleteFlags, DBDocumentImpl outDoc, FieldPath[] paths, Map<String, FieldPath> fieldPathMap) {
        SerializationContext ctx = new SerializationContext();
        if (decodeTimestamp) {
            ctx.setDecodeTimestamp(decodeTimestamp);
        }
        ctx.setPreserveDeleteTime(preserveDeleteFlags);
        if (paths != null && paths.length > 0) {
            ctx.setProjectedPaths(paths, jsonPathMap);
        }
        ctx.decode(map, jsonPathMap, idToCFNameMap, fieldPathMap, outDoc);
    }

    public static void decodeInternal(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean decodeTimestamp, boolean preserveDeleteFlags, DBDocumentImpl outDoc, String[] paths, Map<String, FieldPath> fieldPathMap) {
        SerializationContext ctx = new SerializationContext();
        if (decodeTimestamp) {
            ctx.setDecodeTimestamp(decodeTimestamp);
        }
        ctx.setPreserveDeleteTime(preserveDeleteFlags);
        if (paths != null && paths.length > 0) {
            ctx.setProjectedPaths(paths, jsonPathMap);
        }
        ctx.decode(map, jsonPathMap, idToCFNameMap, fieldPathMap, outDoc);
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap) {
        DBDocumentImpl doc = new DBDocumentImpl();
        RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, false, false, doc, null, null);
        return doc;
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowKey, boolean excludeId, boolean cacheEncoded, boolean decodeTimestamp, boolean preserveDeleteFlags, String[] paths, Map<String, FieldPath> fieldPathMap) {
        return RowcolCodec.decode(map, jsonPathMap, idToCFNameMap, rowKey, excludeId, cacheEncoded, decodeTimestamp, preserveDeleteFlags, false, paths, fieldPathMap);
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowKeyBuffer, boolean excludeId, boolean cacheEncoded, boolean insertionOrder, boolean decodeTimestamp, boolean preserveDeleteFlags, String[] paths, Map<String, FieldPath> fieldPathMap) {
        if (rowKeyBuffer != null && !rowKeyBuffer.hasRemaining()) {
            KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFrom("");
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(kv, excludeId);
            return doc;
        }
        if (!cacheEncoded) {
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(IdCodec.decode(rowKeyBuffer), excludeId);
            RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, decodeTimestamp, preserveDeleteFlags, doc, paths, fieldPathMap);
            return doc;
        }
        DBDocumentImpl r = new DBDocumentImpl();
        r.setSerializedJson(map, jsonPathMap, idToCFNameMap, rowKeyBuffer, excludeId, insertionOrder, decodeTimestamp, preserveDeleteFlags, paths, fieldPathMap);
        return r;
    }

    public static DBDocumentImpl decodeIndexData(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, Map<Integer, FieldPath> fpIdxTofpMap, ByteBuffer rowKey, boolean excludeId, List<IndexFieldDesc> indexedFields, boolean insertionOrder, boolean decodeTimestamp, boolean preserveDeleteFlags, FieldPath[] paths, MapRDBIndexImpl IndexTable, Map<String, FieldPath> fieldPathMap) {
        DBDocumentImpl coveringDoc = new DBDocumentImpl();
        DBDocumentImpl doc = new DBDocumentImpl();
        if (rowKey != null && !rowKey.hasRemaining()) {
            KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFrom("");
            doc.setId(kv, excludeId);
        } else {
            ArrayList<Object> decodedIndexValues = new ArrayList<Object>();
            int numComponents = indexedFields.size();
            boolean[] descendingOrder = new boolean[numComponents];
            for (int i = 0; i < numComponents; ++i) {
                descendingOrder[i] = indexedFields.get(i).getSortOrder() == IndexFieldDesc.Order.Desc;
            }
            IndexRowKeyDecoder keyDecoder = new IndexRowKeyDecoder(IndexTable.isHashed());
            keyDecoder.init(IndexTable.getVersion() == Dbserver.SIndexInfo.Version.v6dot0 ? 0 : 1, descendingOrder);
            keyDecoder.setRowKey(ByteReader.wrap((ByteBuffer)rowKey));
            Value idField = IdCodec.decode(keyDecoder.getPrimaryTableRowKey());
            doc.setId(idField, excludeId);
            RowcolCodec.decodeInternalWithFieldPath(map, jsonPathMap, idToCFNameMap, decodeTimestamp, preserveDeleteFlags, coveringDoc, paths, fieldPathMap);
            Set<String> ks = coveringDoc.keySet();
            for (String key : ks) {
                if (key == null || key == "") continue;
                FieldPath fp = null;
                if (fieldPathMap != null) {
                    fp = fieldPathMap.get(key);
                    if (fp == null) {
                        fp = FieldPath.parseFrom((String)key);
                        fieldPathMap.put(key, fp);
                    }
                } else {
                    fp = FieldPath.parseFrom((String)key);
                }
                if (IndexTable.isArrayIndex()) {
                    int cfId = Integer.parseInt(key.substring(1));
                    String cfPath = IndexTable.getCfPath(cfId);
                    if (cfPath.isEmpty()) {
                        DBDocumentImpl defaultCfDoc = (DBDocumentImpl)coveringDoc.getValue(fp).getMap();
                        for (String dKey : defaultCfDoc.keySet()) {
                            doc.set(dKey, defaultCfDoc.getValue(dKey));
                        }
                        continue;
                    }
                    DBDocumentImpl cfDoc = (DBDocumentImpl)coveringDoc.getValue(fp).getMap();
                    for (String dKey : cfDoc.keySet()) {
                        doc.set(cfPath, cfDoc.getValue(dKey));
                    }
                    continue;
                }
                doc.set(fpIdxTofpMap.get(Integer.parseInt(key)), coveringDoc.getValue(fp));
            }
            Iterator<IndexFieldDesc> fieldItr = indexedFields.iterator();
            block58: for (int cIdx = 0; cIdx < numComponents; ++cIdx) {
                IndexRowKeyComponent encodedFieldValue = keyDecoder.getComponent(cIdx);
                FieldPath fp = null;
                IndexFieldDesc fieldInfo = indexedFields.get(cIdx);
                boolean isUpdateTS = false;
                if (!isUpdateTS) {
                    if (fieldInfo.isFunctional()) {
                        fp = FieldPath.parseFrom((String)("$" + String.valueOf(cIdx)));
                        fieldItr.next();
                    } else {
                        fp = fieldItr.next().getFieldPath();
                    }
                } else {
                    fieldItr.next();
                }
                if (!((IndexFieldDescImpl)fieldInfo).getIsArray()) {
                    block2 : switch (encodedFieldValue.getType()) {
                        case 1: {
                            try {
                                doc.set(fp, encodedFieldValue.getString());
                                break;
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new UnsupportedOperationException("Encoding UTF-8 is not a supported.");
                            }
                        }
                        case 3: {
                            doc.set(fp, encodedFieldValue.getBoolean());
                            break;
                        }
                        case 4: {
                            doc.set(fp, encodedFieldValue.getByteArray());
                            break;
                        }
                        case 11: {
                            switch (encodedFieldValue.getOrigType()) {
                                case 5: {
                                    doc.set(fp, encodedFieldValue.getByte());
                                    break block2;
                                }
                                case 6: {
                                    doc.set(fp, encodedFieldValue.getShort());
                                    break block2;
                                }
                                case 7: {
                                    doc.set(fp, encodedFieldValue.getInt());
                                    break block2;
                                }
                                case 8: {
                                    doc.set(fp, encodedFieldValue.getLong());
                                    break block2;
                                }
                                case 9: {
                                    doc.set(fp, encodedFieldValue.getFloat());
                                    break block2;
                                }
                                case 10: {
                                    doc.set(fp, encodedFieldValue.getDouble());
                                    break block2;
                                }
                            }
                            throw new UnsupportedOperationException(encodedFieldValue.getOrigType() + " is not a supported original type for index field.");
                        }
                        case 13: {
                            if (!isUpdateTS) {
                                doc.set(fp, encodedFieldValue.getTimestamp());
                                break;
                            }
                            doc.set(Constants.LAST_MODIFIED_TIMESTAMP_FP, encodedFieldValue.getTimestamp());
                            break;
                        }
                        case 14: {
                            doc.set(fp, encodedFieldValue.getDate());
                            break;
                        }
                        case 12: {
                            doc.set(fp, encodedFieldValue.getTime());
                            break;
                        }
                        case 15: {
                            doc.setNull(fp);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 18: {
                            doc.set(fp, (Map)encodedFieldValue.getMap().map_);
                            break;
                        }
                        case 17: {
                            doc.set(fp, (List)encodedFieldValue.getArray().array_);
                            break;
                        }
                        case 16: {
                            String errMsgPrefix = "Indexed field " + encodedFieldValue.getError().idx + ": ";
                            switch (encodedFieldValue.getError().id) {
                                case 1: {
                                    doc.set("$ERROR", "KEY_IS_TOO_LONG");
                                    break;
                                }
                                case -2: {
                                    doc.set("$ERROR", errMsgPrefix + "ARRAYS_ARE_NOT_SUPPORTED");
                                    break;
                                }
                                case -1: {
                                    doc.set("$ERROR", errMsgPrefix + "MAPS_ARE_NOT_SUPPORTED");
                                    break;
                                }
                                case 2: {
                                    doc.set("$ERROR", errMsgPrefix + "INVALID_CAST");
                                }
                            }
                            numComponents = 1;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(encodedFieldValue.getType() + " is not a supported type for index field.");
                        }
                    }
                }
                if (!IndexTable.decodeIndexValues()) continue;
                switch (encodedFieldValue.getType()) {
                    case 1: {
                        try {
                            decodedIndexValues.add(encodedFieldValue.getString());
                            continue block58;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new UnsupportedOperationException("Encoding UTF-8 is not a supported.");
                        }
                    }
                    case 3: {
                        decodedIndexValues.add(encodedFieldValue.getBoolean());
                        continue block58;
                    }
                    case 4: {
                        decodedIndexValues.add(ByteBufs.wrap(encodedFieldValue.getByteArray()));
                        continue block58;
                    }
                    case 11: {
                        switch (encodedFieldValue.getOrigType()) {
                            case 5: {
                                decodedIndexValues.add(encodedFieldValue.getByte());
                                continue block58;
                            }
                            case 6: {
                                decodedIndexValues.add(encodedFieldValue.getShort());
                                continue block58;
                            }
                            case 7: {
                                decodedIndexValues.add(encodedFieldValue.getInt());
                                continue block58;
                            }
                            case 8: {
                                decodedIndexValues.add(encodedFieldValue.getLong());
                                continue block58;
                            }
                            case 9: {
                                decodedIndexValues.add(Float.valueOf(encodedFieldValue.getFloat()));
                                continue block58;
                            }
                            case 10: {
                                decodedIndexValues.add(encodedFieldValue.getDouble());
                                continue block58;
                            }
                        }
                        throw new UnsupportedOperationException(encodedFieldValue.getOrigType() + " is not a supported original type for index field.");
                    }
                    case 13: {
                        decodedIndexValues.add(encodedFieldValue.getTimestamp());
                        continue block58;
                    }
                    case 14: {
                        decodedIndexValues.add(encodedFieldValue.getDate());
                        continue block58;
                    }
                    case 12: {
                        decodedIndexValues.add(encodedFieldValue.getTime());
                        continue block58;
                    }
                    case 15: {
                        decodedIndexValues.add(null);
                        continue block58;
                    }
                    case 2: {
                        decodedIndexValues.add("$JSONMISSINGVALUE");
                        continue block58;
                    }
                    case 18: {
                        decodedIndexValues.add(encodedFieldValue.getMap().map_);
                        continue block58;
                    }
                    case 17: {
                        decodedIndexValues.add(encodedFieldValue.getArray().array_);
                        continue block58;
                    }
                    case 16: {
                        decodedIndexValues.add("$ERROR");
                        numComponents = 1;
                        continue block58;
                    }
                    default: {
                        throw new UnsupportedOperationException(encodedFieldValue.getType() + " is not a supported type for index field.");
                    }
                }
            }
            if (IndexTable.decodeIndexValues()) {
                doc.set("$idx", (List)decodedIndexValues);
            }
        }
        return doc;
    }

    public static Document decode(ByteBuffer input) {
        return RowcolCodec.decode(input, null, true, false, true);
    }

    public static Document decode(ByteBuffer input, ByteBuffer rowKey, boolean excludeId, boolean decodeTimestamp, boolean preserveDeleteFlags) {
        assert (input.order() == ByteOrder.LITTLE_ENDIAN);
        if (input.position() == input.limit()) {
            return null;
        }
        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
        ByteBuffer cachedBuffer = input.duplicate();
        cachedBuffer.mark();
        cachedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        bufferMap.put(0, cachedBuffer);
        DBDocumentImpl doc = new DBDocumentImpl();
        doc.setId(IdCodec.decode(rowKey), excludeId);
        RowcolCodec.decodeInternal(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP, decodeTimestamp, preserveDeleteFlags, doc, null, null);
        return doc;
    }

    public static DocumentMutation decodeMutation(ByteBuffer input, boolean needsRead) {
        return MutationImpl.fromSerializedValue(input, needsRead);
    }
}

