/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.indexrowkeyfmt.CompositeComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.utils.ByteReader;
import org.apache.commons.lang.mutable.MutableInt;
import org.ojai.Document;
import org.ojai.DocumentBuilder;

public class MapComponent
extends CompositeComponent {
    private OMap value_;
    private int encodingSize_;

    public MapComponent(boolean missingAndNullFirst, boolean descendingOrder, boolean root) {
        super(missingAndNullFirst, descendingOrder, (byte)18, root);
        this.value_ = null;
    }

    public MapComponent(boolean missingAndNullFirst, boolean descendingOrder) {
        super(missingAndNullFirst, descendingOrder, (byte)18, false);
        this.value_ = null;
    }

    public MapComponent(OMap value, boolean missingAndNullFirst, boolean descendingOrder, boolean root) {
        super(value, missingAndNullFirst, descendingOrder, (byte)18, root);
        this.value_ = value;
    }

    public MapComponent(OMap value, boolean missingAndNullFirst, boolean descendingOrder) {
        super(value, missingAndNullFirst, descendingOrder, (byte)18, false);
        this.value_ = value;
    }

    @Override
    public byte getMarker() {
        return this.descendingOrder_ ? (byte)-17 : 16;
    }

    @Override
    public OMap getMap() {
        return this.value_;
    }

    @Override
    public boolean canPotentiallyContributeToOriginalTypeEncoding(int i) {
        return (i & 1) != 0;
    }

    @Override
    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset) {
        DocumentBuilder docBld = MapRDBImpl.newDocumentBuilder();
        docBld.addNewMap();
        int decodedSize = this.decodeChildren(buf, offset, bufSize, origTypeOffset, docBld);
        docBld.endMap();
        assert (this.root_);
        Document d = docBld.getDocument();
        this.document_ = d.asMap();
        this.value_ = new OMap(d.asMap());
        this.setIsDecoded();
        return decodedSize;
    }

    @Override
    public int decodeChildren(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset, DocumentBuilder docBld) {
        if (buf.getByte(offset) != this.getMarker()) {
            return -1;
        }
        int offsetLimit = offset + bufSize;
        int origTypeInit = origTypeOffset.intValue();
        ++offset;
        offset += 2;
        if (this.root_) {
            offset += 2;
        }
        while (offset < offsetLimit) {
            IndexRowKeyComponent irkcK = this.getComponent(buf, offset);
            if (irkcK == null) {
                this.componentArrayReset();
                return -1;
            }
            int decodedSize = irkcK.decode(buf, offset, irkcK.getEncodingSize(), null);
            if (decodedSize < 0) {
                this.componentArrayReset();
                return -1;
            }
            IndexRowKeyComponent irkcV = this.getComponent(buf, offset += irkcK.getFullEncodingSize());
            if (irkcV == null) {
                this.componentArrayReset();
                return -1;
            }
            decodedSize = irkcV.decode(buf, offset, irkcV.getEncodingSize(), origTypeOffset, docBld, new String(irkcK.getByteArray()));
            if (decodedSize < 0) {
                this.componentArrayReset();
                return -1;
            }
            offset += irkcV.getFullEncodingSize();
        }
        if (this.root_ && origTypeOffset.intValue() - origTypeInit != this.getOrigTypeEncodingSize()) {
            this.componentArrayReset();
            return -1;
        }
        if (offset != offsetLimit) {
            this.componentArrayReset();
            return -1;
        }
        return bufSize;
    }
}

