/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.FamilyDescriptor;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.annotation.API;

@API.Internal
public class FamilyDescriptorImpl
implements FamilyDescriptor {
    private Dbserver.SchemaFamily.Builder schemaFamily_;
    private FieldPath jsonFamilyPath_;
    public static final Dbserver.ColumnFamilyAttr DEFAULT_COLUMN_FAMILY_ATTR;

    public FamilyDescriptorImpl() {
        this(FamilyDescriptorImpl.defaultSchemaFamily(), FieldPath.EMPTY);
    }

    public FamilyDescriptorImpl(String familyName, String jsonPath) {
        this(FamilyDescriptorImpl.defaultSchemaFamily().setName(familyName), FieldPath.parseFrom((String)jsonPath));
    }

    public FamilyDescriptorImpl(String familyName, FieldPath jsonPath) {
        this(FamilyDescriptorImpl.defaultSchemaFamily().setName(familyName), jsonPath);
    }

    FamilyDescriptorImpl(Dbserver.ColumnFamilyAttr cfAttr) {
        this(cfAttr.getSchFamily().toBuilder(), FieldPath.parseFrom((String)cfAttr.getJsonFamilyPath()));
    }

    FamilyDescriptorImpl(FamilyDescriptorImpl other) {
        this(other.schemaFamily_.clone(), other.jsonFamilyPath_);
    }

    FamilyDescriptorImpl(Dbserver.SchemaFamily.Builder schemaFamily, FieldPath jsonFamilyPath) {
        Preconditions.checkNotNull((Object)schemaFamily, (Object)"SchemaFamily must be initalized to a non-null value");
        Preconditions.checkNotNull((Object)jsonFamilyPath, (Object)"FieldPath must be initalized to a non-null value");
        this.schemaFamily_ = schemaFamily;
        this.setJsonFieldPath(jsonFamilyPath);
    }

    public int getId() {
        return this.schemaFamily_.getId();
    }

    public Dbserver.SchemaFamily.Builder getSchemaFamily() {
        return this.schemaFamily_.clone();
    }

    public boolean hasInMemory() {
        return this.schemaFamily_.hasInMemory();
    }

    public void clearInMemory() {
        this.schemaFamily_.clearInMemory();
    }

    @Override
    public boolean hasName() {
        return this.schemaFamily_.hasName();
    }

    @Override
    public String getName() {
        return this.schemaFamily_.getName();
    }

    @Override
    public FamilyDescriptor setName(String name) {
        this.schemaFamily_.setName(name);
        return this;
    }

    @Override
    public FieldPath getJsonFieldPath() {
        return this.jsonFamilyPath_;
    }

    @Override
    public FamilyDescriptor setJsonFieldPath(String fieldPath) {
        return this.setJsonFieldPath(FieldPath.parseFrom((String)fieldPath));
    }

    @Override
    public FamilyDescriptor setJsonFieldPath(FieldPath fieldPath) {
        this.validateFamilyPath(fieldPath);
        this.jsonFamilyPath_ = fieldPath;
        return this;
    }

    @Override
    public long getTTL() {
        return this.schemaFamily_.getTtl() / 1000L;
    }

    @Override
    public FamilyDescriptor setTTL(long ttl) {
        this.schemaFamily_.setTtl(ttl * 1000L);
        return this;
    }

    @Override
    public boolean isInMemory() {
        return this.schemaFamily_.getInMemory();
    }

    @Override
    public FamilyDescriptor setInMemory(boolean inMemory) {
        this.schemaFamily_.setInMemory(inMemory);
        return this;
    }

    @Override
    public FamilyDescriptor.Compression getCompression() {
        return this.schemaFamily_.hasCompression() ? this.proto2Compression(this.schemaFamily_.getCompression()) : FamilyDescriptor.Compression.Inherited;
    }

    @Override
    public FamilyDescriptor setCompression(FamilyDescriptor.Compression compression) {
        Common.FileCompressionType proto = this.compression2Proto(compression);
        if (proto != null) {
            this.schemaFamily_.setCompression(proto);
        } else {
            this.schemaFamily_.clearCompression();
        }
        return this;
    }

    private Common.FileCompressionType compression2Proto(FamilyDescriptor.Compression compression) {
        switch (compression) {
            case Inherited: {
                return null;
            }
            case LZ4: {
                return Common.FileCompressionType.FCT_LZ4;
            }
            case LZF: {
                return Common.FileCompressionType.FCT_LZF;
            }
            case ZLIB: {
                return Common.FileCompressionType.FCT_ZLIB;
            }
        }
        return Common.FileCompressionType.FCT_OFF;
    }

    private FamilyDescriptor.Compression proto2Compression(Common.FileCompressionType compression) {
        switch (compression) {
            case FCT_LZ4: {
                return FamilyDescriptor.Compression.LZ4;
            }
            case FCT_LZF: 
            case FCT_OLDLZF: {
                return FamilyDescriptor.Compression.LZF;
            }
            case FCT_ZLIB: {
                return FamilyDescriptor.Compression.ZLIB;
            }
        }
        return FamilyDescriptor.Compression.None;
    }

    private void validateFamilyPath(FieldPath fieldPath) {
        for (FieldSegment seg : fieldPath) {
            if (!seg.isArray()) continue;
            throw new IllegalArgumentException("A column family FieldPath cannot have array segments.");
        }
    }

    private static Dbserver.SchemaFamily.Builder defaultSchemaFamily() {
        return Dbserver.SchemaFamily.newBuilder().setInMemory(false).setMinVersions(0).setMaxVersions(1).setCompression(Common.FileCompressionType.FCT_LZ4);
    }

    public String toString() {
        return "{\"Id\": " + this.getId() + ", \"Name\": \"" + this.getName() + "\", \"JsonFieldPath\": \"" + this.getJsonFieldPath() + "\", \"TTL\": " + this.getTTL() + ", \"InMemory\": " + (this.hasInMemory() ? this.isInMemory() : false) + ", \"Compression\": \"" + (Object)((Object)this.getCompression()) + "\"}";
    }

    @Override
    public FamilyDescriptorImpl clone() {
        return new FamilyDescriptorImpl(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.jsonFamilyPath_.hashCode();
        result = 31 * result + (int)this.getTTL();
        result = 31 * result + (this.hasInMemory() && this.isInMemory() ? 1 : 0);
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getCompression() == null ? 0 : this.getCompression().ordinal());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FamilyDescriptorImpl other = (FamilyDescriptorImpl)obj;
        if (this.jsonFamilyPath_ == null ? other.jsonFamilyPath_ != null : !this.jsonFamilyPath_.equals((Object)other.jsonFamilyPath_)) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getCompression() == null ? other.getCompression() != null : !this.getCompression().equals((Object)other.getCompression())) {
            return false;
        }
        if (this.hasInMemory() != other.hasInMemory()) {
            return false;
        }
        if (this.hasInMemory() && other.hasInMemory() && this.isInMemory() != other.isInMemory()) {
            return false;
        }
        return this.getTTL() == other.getTTL();
    }

    static {
        Dbserver.SchemaFamily.Builder schemaFamily = FamilyDescriptorImpl.defaultSchemaFamily().setName("default");
        DEFAULT_COLUMN_FAMILY_ATTR = Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(schemaFamily).build();
    }
}

