/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.slider.server.services.workflow.ServiceParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCompositeService
extends CompositeService
implements ServiceParent,
ServiceStateChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowCompositeService.class);
    private volatile Configuration configuration;

    public WorkflowCompositeService(String name) {
        super(name);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    protected void setConfig(Configuration conf) {
        super.setConfig(conf);
        this.configuration = conf;
    }

    public WorkflowCompositeService() {
        this("WorkflowCompositeService");
    }

    public WorkflowCompositeService(String name, Service ... children) {
        this(name);
        Service[] serviceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Service child = serviceArray[n2];
            this.addService(child);
            ++n2;
        }
    }

    public WorkflowCompositeService(String name, List<Service> children) {
        this(name);
        for (Service child : children) {
            this.addService(child);
        }
    }

    @Override
    public synchronized void addService(Service service) {
        Preconditions.checkArgument((service != null ? 1 : 0) != 0, (Object)"null service argument");
        service.registerServiceListener((ServiceStateChangeListener)this);
        super.addService(service);
    }

    public void stateChanged(Service child) {
        if (this.isInState(Service.STATE.STARTED) && child.isInState(Service.STATE.STOPPED)) {
            Throwable failureCause = child.getFailureCause();
            if (failureCause != null) {
                LOG.info("Child service " + child + " failed", failureCause);
                Exception e = failureCause instanceof Exception ? (Exception)failureCause : new Exception(failureCause);
                this.noteFailure(e);
                this.stop();
            } else {
                LOG.info("Child service completed {}", (Object)child);
                if (this.areAllChildrenStopped()) {
                    LOG.info("All children are halted: stopping");
                    this.stop();
                }
            }
        }
    }

    private boolean areAllChildrenStopped() {
        List children = this.getServices();
        boolean stopped = true;
        for (Service child : children) {
            if (child.isInState(Service.STATE.STOPPED)) continue;
            stopped = false;
            break;
        }
        return stopped;
    }
}

