/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.ActionStopQueue;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueService;
import org.apache.slider.server.appmaster.state.AppState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueExecutor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(QueueExecutor.class);
    private final SliderAppMaster appMaster;
    private final QueueService actionQueues;
    private final AppState appState;

    public QueueExecutor(SliderAppMaster appMaster, QueueService actionQueues) {
        Preconditions.checkNotNull((Object)appMaster);
        Preconditions.checkNotNull((Object)actionQueues);
        this.appMaster = appMaster;
        this.actionQueues = actionQueues;
        this.appState = appMaster.getAppState();
    }

    @VisibleForTesting
    public QueueExecutor(QueueService actionQueues) {
        Preconditions.checkNotNull((Object)actionQueues);
        this.appMaster = null;
        this.appState = null;
        this.actionQueues = actionQueues;
    }

    @Override
    public void run() {
        block4: {
            AsyncAction take = null;
            try {
                log.info("Queue Executor run() started");
                do {
                    take = this.actionQueues.actionQueue.take();
                    log.debug("Executing {}", (Object)take);
                    take.execute(this.appMaster, this.actionQueues, this.appState);
                    log.debug("Completed {}", (Object)take);
                } while (!(take instanceof ActionStopQueue));
                log.info("Queue Executor run() stopped");
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                log.error("Exception processing {}: {}", new Object[]{take, e, e});
                if (this.appMaster == null) break block4;
                this.appMaster.onExceptionInThread(Thread.currentThread(), e);
            }
        }
        this.actionQueues.complete();
    }
}

