/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.agent.application.metadata.Application;
import org.apache.slider.providers.agent.application.metadata.ApplicationPackage;
import org.apache.slider.providers.agent.application.metadata.Component;
import org.apache.slider.providers.agent.application.metadata.ConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metainfo {
    protected static final Logger log = LoggerFactory.getLogger(Metainfo.class);
    public static String VERSION_TWO_ZERO = "2.0";
    public static String VERSION_TWO_ONE = "2.1";
    String schemaVersion;
    ApplicationPackage applicationPackage;
    Application application;

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public void setApplicationPackage(ApplicationPackage pkg) {
        this.applicationPackage = pkg;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Component getApplicationComponent(String roleGroup) {
        if (this.application == null) {
            log.error("Malformed app definition: Expect application as the top level element for metainfo");
        } else {
            for (Component component : this.application.getComponents()) {
                if (!component.getName().equals(roleGroup)) continue;
                return component;
            }
        }
        return null;
    }

    public List<ConfigFile> getComponentConfigFiles(String roleGroup) {
        ArrayList<ConfigFile> componentConfigFiles = new ArrayList<ConfigFile>();
        componentConfigFiles.addAll(this.application.getConfigFiles());
        Component component = this.getApplicationComponent(roleGroup);
        if (component != null) {
            componentConfigFiles.addAll(component.getConfigFiles());
        }
        return componentConfigFiles;
    }

    public void validate() throws SliderException {
        if (!VERSION_TWO_ONE.equals(this.schemaVersion) && !VERSION_TWO_ZERO.equals(this.schemaVersion)) {
            throw new SliderException("Unsupported version " + this.getSchemaVersion());
        }
        if (this.application != null) {
            this.application.validate(this.schemaVersion);
        }
        if (this.applicationPackage != null) {
            this.applicationPackage.validate(this.schemaVersion);
        }
    }

    public static void checkNonNull(String value, String field, String type) throws SliderException {
        if (SliderUtils.isUnset(value)) {
            throw new SliderException(String.valueOf(type) + "." + field + " cannot be null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Metainfo [schemaVersion=");
        builder.append(this.schemaVersion);
        builder.append(", applicationPackage=");
        builder.append(this.applicationPackage);
        builder.append(", application=");
        builder.append(this.application);
        builder.append("]");
        return builder.toString();
    }
}

