/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.providers.agent.Command;
import org.apache.slider.providers.agent.ComponentInstanceState;
import org.apache.slider.providers.agent.State;
import org.apache.slider.providers.agent.application.metadata.CommandOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentCommandOrder {
    public static final Logger log = LoggerFactory.getLogger(ComponentCommandOrder.class);
    private static char SPLIT_CHAR = (char)45;
    Map<Command, Map<String, List<ComponentState>>> dependencies = new HashMap<Command, Map<String, List<ComponentState>>>();
    Map<String, Collection<String>> prefixRoleMap = new HashMap<String, Collection<String>>();
    Map<String, String> rolePrefixMap = new HashMap<String, String>();

    public ComponentCommandOrder() {
    }

    public ComponentCommandOrder(List<CommandOrder> commandOrders, ConfTreeOperations resources) {
        this.mergeCommandOrders(commandOrders, resources);
    }

    void mergeCommandOrders(List<CommandOrder> commandOrders, ConfTreeOperations resources) {
        for (String component : resources.getComponentNames()) {
            String prefix = SliderUtils.trimPrefix(resources.getComponentOpt(component, "role.prefix", null));
            if (prefix == null) continue;
            this.rolePrefixMap.put(component, prefix);
            if (!this.prefixRoleMap.containsKey(prefix)) {
                this.prefixRoleMap.put(prefix, new HashSet());
            }
            this.prefixRoleMap.get(prefix).add(component);
        }
        if (commandOrders != null && commandOrders.size() > 0) {
            for (CommandOrder commandOrder : commandOrders) {
                List<ComponentState> requirements;
                ComponentCommand componentCmd = this.getComponentCommand(commandOrder.getCommand(), resources);
                String requires = commandOrder.getRequires();
                List<ComponentState> requiredStates = this.parseRequiredStates(requires, resources);
                if (requiredStates.size() <= 0) continue;
                Map<String, List<ComponentState>> compDep = this.dependencies.get((Object)componentCmd.command);
                if (compDep == null) {
                    compDep = new HashMap<String, List<ComponentState>>();
                    this.dependencies.put(componentCmd.command, compDep);
                }
                if ((requirements = compDep.get(componentCmd.componentName)) == null) {
                    requirements = new ArrayList<ComponentState>();
                    compDep.put(componentCmd.componentName, requirements);
                }
                requirements.addAll(requiredStates);
            }
        }
    }

    private List<ComponentState> parseRequiredStates(String requires, ConfTreeOperations resources) {
        if (requires == null || requires.length() < 2) {
            throw new IllegalArgumentException("Input cannot be null and must contain component and state.");
        }
        String[] componentStates = requires.split(",");
        ArrayList<ComponentState> retList = new ArrayList<ComponentState>();
        String[] stringArray = componentStates;
        int n = componentStates.length;
        int n2 = 0;
        while (n2 < n) {
            String componentStateStr = stringArray[n2];
            retList.add(this.getComponentState(componentStateStr, resources));
            ++n2;
        }
        return retList;
    }

    private ComponentCommand getComponentCommand(String compCmdStr, ConfTreeOperations resources) {
        if (compCmdStr == null || compCmdStr.trim().length() < 2) {
            throw new IllegalArgumentException("Input cannot be null and must contain component and command.");
        }
        int splitIndex = (compCmdStr = compCmdStr.trim()).lastIndexOf(SPLIT_CHAR);
        if (splitIndex == -1 || splitIndex == 0 || splitIndex == compCmdStr.length() - 1) {
            throw new IllegalArgumentException("Input does not appear to be well-formed.");
        }
        String compStr = compCmdStr.substring(0, splitIndex);
        String cmdStr = compCmdStr.substring(splitIndex + 1);
        if (resources.getComponent(compStr) == null && !this.prefixRoleMap.containsKey(compStr)) {
            throw new IllegalArgumentException("Component " + compStr + " specified" + " in command order does not exist");
        }
        Command cmd = Command.valueOf(cmdStr);
        if (cmd != Command.START) {
            throw new IllegalArgumentException("Dependency order can only be specified for START.");
        }
        return new ComponentCommand(compStr, cmd);
    }

    private ComponentState getComponentState(String compStStr, ConfTreeOperations resources) {
        if (compStStr == null || compStStr.trim().length() < 2) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        int splitIndex = (compStStr = compStStr.trim()).lastIndexOf(SPLIT_CHAR);
        if (splitIndex == -1 || splitIndex == 0 || splitIndex == compStStr.length() - 1) {
            throw new IllegalArgumentException("Input does not appear to be well-formed.");
        }
        String compStr = compStStr.substring(0, splitIndex);
        String stateStr = compStStr.substring(splitIndex + 1);
        if (resources.getComponent(compStr) == null && !this.prefixRoleMap.containsKey(compStr)) {
            throw new IllegalArgumentException("Component " + compStr + " specified" + " in command order does not exist");
        }
        State state = State.valueOf(stateStr);
        if (state != State.STARTED && state != State.INSTALLED) {
            throw new IllegalArgumentException("Dependency order can only be specified against STARTED/INSTALLED.");
        }
        return new ComponentState(compStr, state);
    }

    public boolean canExecute(String component, Command command, Collection<ComponentInstanceState> currentStates) {
        String prefix;
        if (!this.dependencies.containsKey((Object)command)) {
            return true;
        }
        ArrayList required = new ArrayList();
        if (this.dependencies.get((Object)command).containsKey(component)) {
            required.addAll(this.dependencies.get((Object)command).get(component));
        }
        if ((prefix = this.rolePrefixMap.get(component)) != null && this.dependencies.get((Object)command).containsKey(prefix)) {
            required.addAll(this.dependencies.get((Object)command).get(prefix));
        }
        for (ComponentState stateToMatch : required) {
            for (ComponentInstanceState currState : currentStates) {
                log.debug("Checking schedule {} {} against dependency {} is {}", new Object[]{component, command, currState.getComponentName(), currState.getState()});
                if (!currState.getComponentName().equals(stateToMatch.componentName) && (!this.prefixRoleMap.containsKey(stateToMatch.componentName) || !this.prefixRoleMap.get(stateToMatch.componentName).contains(currState.getComponentName())) || currState.getState() == stateToMatch.state) continue;
                if (stateToMatch.state == State.STARTED) {
                    log.info("Cannot schedule {} {} as dependency {} is {}", new Object[]{component, command, currState.getComponentName(), currState.getState()});
                    return false;
                }
                if (currState.getState() == State.STARTING || currState.getState() == State.STARTED) continue;
                log.info("Cannot schedule {} {} as dependency {} is {}", new Object[]{component, command, currState.getComponentName(), currState.getState()});
                return false;
            }
        }
        return true;
    }

    static class ComponentCommand {
        public String componentName;
        public Command command;

        public ComponentCommand(String componentName, Command command) {
            this.componentName = componentName;
            this.command = command;
        }
    }

    static class ComponentState {
        public String componentName;
        public State state;

        public ComponentState(String componentName, State state) {
            this.componentName = componentName;
            this.state = state;
        }
    }
}

