/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.slider.client.ClientUtils;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.AbstractLauncher;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.providers.AbstractClientProvider;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderUtils;
import org.apache.slider.providers.agent.AgentKeys;
import org.apache.slider.providers.agent.AgentProviderService;
import org.apache.slider.providers.agent.AgentRoles;
import org.apache.slider.providers.agent.AgentUtils;
import org.apache.slider.providers.agent.application.metadata.Application;
import org.apache.slider.providers.agent.application.metadata.Component;
import org.apache.slider.providers.agent.application.metadata.ConfigFile;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.MetainfoParser;
import org.apache.slider.providers.agent.application.metadata.OSPackage;
import org.apache.slider.providers.agent.application.metadata.OSSpecific;
import org.apache.slider.providers.agent.application.metadata.Package;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentClientProvider
extends AbstractClientProvider
implements AgentKeys,
SliderKeys {
    protected static final Logger log = LoggerFactory.getLogger(AgentClientProvider.class);
    protected static final String NAME = "agent";
    private static final ProviderUtils providerUtils = new ProviderUtils(log);
    public static final String E_COULD_NOT_READ_METAINFO = "Not a valid app package. Could not read metainfo.";
    protected Map<String, Metainfo> metaInfoMap = new ConcurrentHashMap<String, Metainfo>();

    protected AgentClientProvider(Configuration conf) {
        super(conf);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<ProviderRole> getRoles() {
        return AgentRoles.getRoles();
    }

    @Override
    public void preflightValidateClusterConfiguration(SliderFileSystem sliderFileSystem, String clustername, Configuration configuration, AggregateConf instanceDefinition, Path clusterDirPath, Path generatedConfDirPath, boolean secure) throws SliderException, IOException {
        String appHome;
        super.preflightValidateClusterConfiguration(sliderFileSystem, clustername, configuration, instanceDefinition, clusterDirPath, generatedConfDirPath, secure);
        String appDef = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations());
        Path appDefPath = new Path(appDef);
        sliderFileSystem.verifyFileExists(appDefPath);
        String agentConf = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("agent.conf", "");
        if (StringUtils.isNotEmpty((String)agentConf)) {
            sliderFileSystem.verifyFileExists(new Path(agentConf));
        }
        if (SliderUtils.isUnset(appHome = instanceDefinition.getAppConfOperations().getGlobalOptions().get("agent.package.root"))) {
            String agentImage = instanceDefinition.getInternalOperations().get("internal.application.image.path");
            sliderFileSystem.verifyFileExists(new Path(agentImage));
        }
    }

    @Override
    public void validateInstanceDefinition(AggregateConf instanceDefinition, SliderFileSystem fs) throws SliderException {
        super.validateInstanceDefinition(instanceDefinition, fs);
        log.debug("Validating conf {}", (Object)instanceDefinition);
        ConfTreeOperations resources = instanceDefinition.getResourceOperations();
        providerUtils.validateNodeCount(instanceDefinition, "echo", 0, -1);
        String appDef = null;
        try {
            appDef = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations());
        }
        catch (BadConfigException bce) {
            throw new BadConfigException("Application definition must be provided. " + bce.getMessage());
        }
        log.info("Validating app definition {}", (Object)appDef);
        String extension = appDef.substring(appDef.lastIndexOf(".") + 1, appDef.length());
        if (!"zip".equals(extension.toLowerCase(Locale.ENGLISH))) {
            throw new BadConfigException("App definition must be packaged as a .zip file. File provided is " + appDef);
        }
        Set<String> names = resources.getComponentNames();
        names.remove("slider-appmaster");
        HashMap<Integer, String> priorityMap = new HashMap<Integer, String>();
        for (String name : names) {
            int count;
            MapOperations componentConfig;
            Component componentDef;
            try {
                appDef = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations(), name);
            }
            catch (BadConfigException bce) {
                throw new BadConfigException("Application definition must be provided. " + bce.getMessage());
            }
            Metainfo metaInfo = this.getMetainfo(fs, appDef);
            MapOperations component = resources.getMandatoryComponent(name);
            if (metaInfo != null && (componentDef = metaInfo.getApplicationComponent(AgentUtils.getMetainfoComponentName(name, instanceDefinition.getAppConfOperations()))) == null) {
                throw new BadConfigException("Component %s is not a member of application.", name);
            }
            int priority = component.getMandatoryOptionInt("yarn.role.priority");
            if (priority <= 0) {
                throw new BadConfigException("Component %s %s value out of range %d", name, "yarn.role.priority", priority);
            }
            String existing = (String)priorityMap.get(priority);
            if (existing != null) {
                throw new BadConfigException("Component %s has a %s value %d which duplicates that of %s", name, "yarn.role.priority", priority, existing);
            }
            priorityMap.put(priority, name);
            if (metaInfo == null) continue;
            Component componentDef2 = metaInfo.getApplicationComponent(AgentUtils.getMetainfoComponentName(name, instanceDefinition.getAppConfOperations()));
            if ("CLIENT".equals(componentDef2.getCategory())) {
                componentConfig = resources.getMandatoryComponent(name);
                count = componentConfig.getMandatoryOptionInt("yarn.component.instances");
                if (count <= 0) continue;
                throw new BadConfigException("Component %s is of type CLIENT and cannot be instantiated. Use \"slider client install ...\" command instead.", name);
            }
            componentConfig = resources.getMandatoryComponent(name);
            count = componentConfig.getMandatoryOptionInt("yarn.component.instances");
            int definedMinCount = componentDef2.getMinInstanceCountInt();
            int definedMaxCount = componentDef2.getMaxInstanceCountInt();
            if (count >= definedMinCount && count <= definedMaxCount) continue;
            throw new BadConfigException("Component %s, %s value %d out of range. Expected minimum is %d and maximum is %d", name, "yarn.component.instances", count, definedMinCount, definedMaxCount);
        }
    }

    @Override
    public void prepareAMAndConfigForLaunch(SliderFileSystem fileSystem, Configuration serviceConf, AbstractLauncher launcher, AggregateConf instanceDefinition, Path snapshotConfDirPath, Path generatedConfDirPath, Configuration clientConfExtras, String libdir, Path tempPath, boolean miniClusterTestRun) throws IOException, SliderException {
        String agentImage = instanceDefinition.getInternalOperations().get("internal.application.image.path");
        if (SliderUtils.isUnset(agentImage)) {
            Path agentPath = new Path(tempPath.getParent(), NAME);
            log.info("Automatically uploading the agent tarball at {}", (Object)agentPath);
            fileSystem.getFileSystem().mkdirs(agentPath);
            if (ProviderUtils.addAgentTar(this, "slider-agent.tar.gz", fileSystem, agentPath)) {
                instanceDefinition.getInternalOperations().set("internal.application.image.path", new Path(agentPath, "slider-agent.tar.gz").toUri());
            }
        }
    }

    @Override
    public Set<String> getApplicationTags(SliderFileSystem fileSystem, String appDef) throws SliderException {
        Metainfo metaInfo = this.getMetainfo(fileSystem, appDef);
        if (metaInfo == null) {
            log.error("Error retrieving metainfo from {}", (Object)appDef);
            throw new SliderException("Error parsing metainfo file, possibly bad structure.");
        }
        Application application = metaInfo.getApplication();
        HashSet<String> tags = new HashSet<String>();
        tags.add("Name: " + application.getName());
        tags.add("Version: " + application.getVersion());
        tags.add("Description: " + SliderUtils.truncate(application.getComment(), 80));
        return tags;
    }

    @Override
    public void processClientOperation(SliderFileSystem fileSystem, RegistryOperations rops, Configuration configuration, String operation, File clientInstallPath, File appPackage, JSONObject config, String name) throws SliderException {
        block47: {
            File tmpDir = Files.createTempDir();
            log.info("Command is being executed at {}", (Object)tmpDir.getAbsolutePath());
            File appPkgDir = new File(tmpDir, "app_pkg");
            appPkgDir.mkdir();
            File agentPkgDir = new File(tmpDir, "agent_pkg");
            agentPkgDir.mkdir();
            File cmdDir = new File(tmpDir, "command");
            cmdDir.mkdir();
            Metainfo metaInfo = null;
            JSONObject defaultConfig = null;
            try {
                String clientScript;
                block49: {
                    try (ZipInputStream zipInputStream = null;){
                        zipInputStream = new ZipInputStream(new FileInputStream(appPackage));
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        while (zipEntry != null) {
                            log.info("Processing {}", (Object)zipEntry.getName());
                            String filePath = appPkgDir + File.separator + zipEntry.getName();
                            if (!zipEntry.isDirectory()) {
                                FileInputStream input;
                                log.info("Extracting file {}", (Object)filePath);
                                this.extractFile(zipInputStream, filePath);
                                if ("metainfo.xml".equals(zipEntry.getName())) {
                                    input = null;
                                    try {
                                        input = new FileInputStream(filePath);
                                        metaInfo = new MetainfoParser().fromXmlStream(input);
                                    }
                                    catch (Throwable throwable) {
                                        IOUtils.closeStream(input);
                                        throw throwable;
                                    }
                                    IOUtils.closeStream((Closeable)input);
                                } else if ("metainfo.json".equals(zipEntry.getName())) {
                                    input = null;
                                    try {
                                        input = new FileInputStream(filePath);
                                        metaInfo = new MetainfoParser().fromJsonStream(input);
                                    }
                                    finally {
                                        IOUtils.closeStream((Closeable)input);
                                    }
                                } else if ("clientInstallConfig-default.json".equals(zipEntry.getName())) {
                                    try {
                                        defaultConfig = new JSONObject(FileUtils.readFileToString((File)new File(filePath), (Charset)Charset.defaultCharset()));
                                    }
                                    catch (JSONException jex) {
                                        throw new SliderException("Unable to read default client config.", (Throwable)jex);
                                    }
                                }
                            } else {
                                log.info("Creating dir {}", (Object)filePath);
                                File dir = new File(filePath);
                                dir.mkdir();
                            }
                            zipInputStream.closeEntry();
                            zipEntry = zipInputStream.getNextEntry();
                        }
                    }
                    if (metaInfo == null) {
                        throw new BadConfigException(E_COULD_NOT_READ_METAINFO);
                    }
                    clientScript = null;
                    String clientComponent = null;
                    for (Component component : metaInfo.getApplication().getComponents()) {
                        if (!component.getCategory().equals("CLIENT")) continue;
                        clientComponent = component.getName();
                        if (component.getCommandScript() == null) break;
                        clientScript = component.getCommandScript().getScript();
                        break;
                    }
                    if (SliderUtils.isUnset(clientScript)) {
                        File confInstallDir;
                        log.info("Installing CLIENT without script");
                        List<Package> packages = metaInfo.getApplication().getPackages();
                        if (packages.size() > 0) {
                            for (Package pkg : packages) {
                                Object pkgFile;
                                Path pkgPath = fileSystem.buildResourcePath(pkg.getName());
                                if (!fileSystem.isFile(pkgPath) && name != null) {
                                    pkgPath = fileSystem.buildResourcePath(name, pkg.getName());
                                }
                                if (!fileSystem.isFile(pkgPath)) {
                                    throw new IOException("Package doesn't exist as a resource: " + pkg.getName());
                                }
                                if ("archive".equals(pkg.getType())) {
                                    pkgFile = new File(tmpDir, pkg.getName());
                                    fileSystem.copyHdfsFileToLocal(pkgPath, (File)pkgFile);
                                    this.expandTar((File)pkgFile, clientInstallPath);
                                    continue;
                                }
                                pkgFile = new File(clientInstallPath, pkg.getName());
                                fileSystem.copyHdfsFileToLocal(pkgPath, (File)pkgFile);
                            }
                        } else {
                            for (OSSpecific osSpecific : metaInfo.getApplication().getOSSpecifics()) {
                                for (OSPackage pkg : osSpecific.getPackages()) {
                                    if (!"tarball".equals(pkg.getType())) continue;
                                    File pkgFile = new File(appPkgDir, pkg.getName());
                                    this.expandTar(pkgFile, clientInstallPath);
                                }
                            }
                        }
                        if (name == null) {
                            log.warn("Conf files not being generated because no app name was provided");
                            return;
                        }
                        String clientRoot = null;
                        if (config != null) {
                            try {
                                clientRoot = config.getJSONObject("global").getString("client_root");
                            }
                            catch (JSONException jSONException) {
                                log.info("Couldn't read {} from provided client config, falling back on default", (Object)"client_root");
                            }
                        }
                        if (clientRoot == null && defaultConfig != null) {
                            try {
                                clientRoot = defaultConfig.getJSONObject("global").getString("client_root");
                            }
                            catch (JSONException jSONException) {
                                log.info("Couldn't read {} from default client config, using {}", (Object)"client_root", (Object)clientInstallPath);
                            }
                        }
                        if (clientRoot == null) {
                            confInstallDir = clientInstallPath;
                        } else {
                            confInstallDir = new File(new File(clientInstallPath, clientRoot), "conf");
                            if (!confInstallDir.exists()) {
                                confInstallDir.mkdirs();
                            }
                        }
                        String user = RegistryUtils.currentUser();
                        for (ConfigFile configFile : metaInfo.getComponentConfigFiles(clientComponent)) {
                            this.retrieveConfigFile(rops, configuration, configFile, name, user, confInstallDir);
                        }
                        break block47;
                    }
                    log.info("Installing CLIENT using script {}", clientScript);
                    this.expandAgentTar(agentPkgDir);
                    JSONObject commandJson = this.getCommandJson(defaultConfig, config, metaInfo, clientInstallPath, name);
                    FileWriter file = new FileWriter(new File(cmdDir, "command.json"));
                    try {
                        try {
                            file.write(commandJson.toString());
                        }
                        catch (IOException iOException) {
                            log.error("Couldn't write command.json to file");
                            file.flush();
                            file.close();
                            break block49;
                        }
                    }
                    catch (Throwable throwable) {
                        file.flush();
                        file.close();
                        throw throwable;
                    }
                    file.flush();
                    file.close();
                }
                this.runCommand(appPkgDir, agentPkgDir, cmdDir, clientScript);
            }
            catch (IOException ioex) {
                log.warn("Error while executing INSTALL command {}", (Object)ioex.getMessage());
                throw new SliderException("INSTALL client failed.");
            }
        }
    }

    protected void runCommand(File appPkgDir, File agentPkgDir, File cmdDir, String clientScript) throws SliderException {
        int exitCode = 0;
        Exception exp = null;
        try {
            String line;
            String clientScriptPath = String.valueOf(appPkgDir.getAbsolutePath()) + File.separator + "package" + File.separator + clientScript;
            List<String> command = Arrays.asList("python", "-S", clientScriptPath, "INSTALL", String.valueOf(cmdDir.getAbsolutePath()) + File.separator + "command.json", String.valueOf(appPkgDir.getAbsolutePath()) + File.separator + "package", String.valueOf(cmdDir.getAbsolutePath()) + File.separator + "command-out.json", "DEBUG");
            ProcessBuilder pb = new ProcessBuilder(command);
            log.info("Command: " + StringUtils.join(pb.command(), (String)" "));
            pb.environment().put("PYTHONPATH", String.valueOf(agentPkgDir.getAbsolutePath()) + File.separator + "slider-agent" + File.pathSeparator + agentPkgDir.getAbsolutePath() + File.separator + "slider-agent/jinja2");
            log.info("{}={}", (Object)"PYTHONPATH", (Object)pb.environment().get("PYTHONPATH"));
            Process proc = pb.start();
            InputStream stderr = proc.getErrorStream();
            InputStream stdout = proc.getInputStream();
            BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(stdout));
            BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(stderr));
            proc.waitFor();
            while ((line = stdOutReader.readLine()) != null) {
                log.info("Stdout: " + line);
            }
            while ((line = stdErrReader.readLine()) != null) {
                log.info("Stderr: " + line);
            }
            exitCode = proc.exitValue();
            log.info("Exit value is {}", (Object)exitCode);
        }
        catch (IOException e) {
            exp = e;
        }
        catch (InterruptedException e) {
            exp = e;
        }
        if (exitCode != 0) {
            throw new SliderException("INSTALL client failed with exit code " + exitCode);
        }
        if (exp != null) {
            log.error("Error while executing INSTALL command {}. Stack trace {}", (Object)exp.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)exp));
            throw new SliderException("INSTALL client failed.", (Throwable)exp);
        }
    }

    private void expandAgentTar(File agentPkgDir) throws IOException {
        String libDirProp = System.getProperty("slider.libdir");
        File tarFile = new File(libDirProp, "slider-agent.tar.gz");
        this.expandTar(tarFile, agentPkgDir);
    }

    private void expandTar(File tarFile, File destDir) throws IOException {
        log.info("Expanding tar {} to {}", (Object)tarFile, (Object)destDir);
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile))));){
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            while (tarEntry != null) {
                File destPath = new File(destDir, tarEntry.getName());
                File parent = destPath.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    byte[] byteToRead = new byte[1024];
                    try (BufferedOutputStream buffOut = new BufferedOutputStream(new FileOutputStream(destPath));){
                        int len;
                        while ((len = tarIn.read(byteToRead)) != -1) {
                            buffOut.write(byteToRead, 0, len);
                        }
                    }
                }
                if ((tarEntry.getMode() & 0x40) != 0) {
                    destPath.setExecutable(true);
                }
                tarEntry = tarIn.getNextTarEntry();
            }
        }
    }

    private void retrieveConfigFile(RegistryOperations rops, Configuration configuration, ConfigFile configFile, String name, String user, File destDir) throws IOException, SliderException {
        log.info("Retrieving config {} to {}", (Object)configFile.getDictionaryName(), (Object)destDir);
        PublishedConfiguration published = ClientUtils.getConfigFromRegistry(rops, configuration, configFile.getDictionaryName(), name, user, true);
        ClientUtils.saveOrReturnConfig(published, configFile.getType(), destDir, configFile.getFileName());
    }

    protected JSONObject getCommandJson(JSONObject defaultConfig, JSONObject inputConfig, Metainfo metainfo, File clientInstallPath, String name) throws SliderException {
        try {
            JSONObject pkgList = new JSONObject();
            pkgList.put("package_list", (Object)AgentProviderService.getPackageListFromApplication(metainfo.getApplication()));
            JSONObject obj = new JSONObject();
            obj.put("hostLevelParams", (Object)pkgList);
            String user = RegistryUtils.currentUser();
            JSONObject configuration = new JSONObject();
            JSONObject global = new JSONObject();
            global.put("app_install_dir", (Object)clientInstallPath.getAbsolutePath());
            global.put("app_user", (Object)user);
            if (name != null) {
                global.put("app_name", (Object)name);
            }
            if (defaultConfig != null) {
                this.readConfigEntries(defaultConfig, clientInstallPath, global, name, user);
            }
            if (inputConfig != null) {
                this.readConfigEntries(inputConfig, clientInstallPath, global, name, user);
            }
            configuration.put("global", (Object)global);
            obj.put("configurations", (Object)configuration);
            return obj;
        }
        catch (JSONException jex) {
            log.warn("Error while executing INSTALL command {}", (Object)jex.getMessage());
            throw new SliderException("INSTALL client failed.");
        }
    }

    private void readConfigEntries(JSONObject inpConfig, File clientInstallPath, JSONObject globalConfig, String name, String user) throws JSONException {
        JSONObject globalSection = inpConfig.getJSONObject("global");
        Iterator it = globalSection.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = globalSection.getString(key);
            if (SliderUtils.isSet(value)) {
                value = value.replace("{app_install_dir}", clientInstallPath.getAbsolutePath());
                value = value.replace("{app_user}", user);
                if (name != null) {
                    value = value.replace("{app_name}", name);
                }
            }
            if (globalConfig.has(key)) {
                globalConfig.remove(key);
            }
            globalConfig.put(key, (Object)value);
        }
    }

    private void extractFile(ZipInputStream zipInputStream, String filePath) throws IOException {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytesRead = new byte[4096];
            int read = 0;
            while ((read = zipInputStream.read(bytesRead)) != -1) {
                output.write(bytesRead, 0, read);
            }
        }
    }

    private Metainfo getMetainfo(SliderFileSystem fs, String appDef) {
        Metainfo metaInfo = this.metaInfoMap.get(appDef);
        if (fs != null && metaInfo == null) {
            try {
                metaInfo = AgentUtils.getApplicationMetainfo(fs, appDef, false);
                this.metaInfoMap.put(appDef, metaInfo);
            }
            catch (IOException ioe) {
                log.info("Missing metainfo {}", (Object)ioe.getMessage());
            }
            catch (BadConfigException bce) {
                log.info("Bad Configuration {}", (Object)bce.getMessage());
            }
        }
        return metaInfo;
    }
}

