/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;

public class PortScanner {
    private static Pattern NUMBER_RANGE = Pattern.compile("^(\\d+)\\s*-\\s*(\\d+)$");
    private static Pattern SINGLE_NUMBER = Pattern.compile("^\\d+$");
    private List<Integer> remainingPortsToCheck;

    public void setPortRange(String input) throws BadConfigException {
        String[] ranges;
        TreeSet<Integer> inputPorts = new TreeSet<Integer>();
        String[] stringArray = ranges = input.split(",");
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            String range = stringArray[n2];
            if (!range.trim().isEmpty()) {
                Matcher m = SINGLE_NUMBER.matcher(range.trim());
                if (m.find()) {
                    inputPorts.add(Integer.parseInt(m.group()));
                } else {
                    m = NUMBER_RANGE.matcher(range.trim());
                    if (m.find()) {
                        String[] boundaryValues = m.group(0).split("-");
                        int start = Integer.parseInt(boundaryValues[0].trim());
                        int end = Integer.parseInt(boundaryValues[1].trim());
                        if (end < start) {
                            throw new BadConfigException("End of port range is before start: " + range + " in input: " + input);
                        }
                        int i = start;
                        while (i < end + 1) {
                            inputPorts.add(i);
                            ++i;
                        }
                    } else {
                        throw new BadConfigException("Bad port range: " + range + " in input: " + input);
                    }
                }
            }
            ++n2;
        }
        if (inputPorts.size() == 0) {
            throw new BadConfigException("No ports found in range: " + input);
        }
        this.remainingPortsToCheck = new ArrayList<Integer>(inputPorts);
    }

    public List<Integer> getRemainingPortsToCheck() {
        return this.remainingPortsToCheck;
    }

    public int getAvailablePort() throws SliderException, IOException {
        if (this.remainingPortsToCheck != null) {
            return this.getAvailablePortViaPortArray();
        }
        return SliderUtils.getOpenPort();
    }

    private int getAvailablePortViaPortArray() throws SliderException {
        boolean found = false;
        int availablePort = -1;
        Iterator<Integer> portsToCheck = this.remainingPortsToCheck.iterator();
        while (portsToCheck.hasNext() && !found) {
            int portToCheck = portsToCheck.next();
            found = SliderUtils.isPortAvailable(portToCheck);
            if (!found) continue;
            availablePort = portToCheck;
            portsToCheck.remove();
        }
        if (availablePort < 0) {
            throw new SliderException(77, "No available ports found in configured range {}", this.remainingPortsToCheck);
        }
        return availablePort;
    }
}

