/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public abstract class Project
extends SingleRel {
    protected final ImmutableList<RexNode> exps;

    protected Project(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, input);
        assert (rowType != null);
        this.exps = ImmutableList.copyOf(projects);
        this.rowType = rowType;
        assert (this.isValid(Litmus.THROW));
    }

    @Deprecated
    protected Project(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, input, projects, rowType);
        Util.discard(flags);
    }

    protected Project(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getExpressionList("exprs"), input.getRowType("exprs", "fields"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Project.sole(inputs), (List<RexNode>)this.exps, this.rowType);
    }

    public abstract Project copy(RelTraitSet var1, RelNode var2, List<RexNode> var3, RelDataType var4);

    @Deprecated
    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
        Util.discard(flags);
        return this.copy(traitSet, input, projects, rowType);
    }

    @Deprecated
    public boolean isBoxed() {
        return true;
    }

    @Override
    public List<RexNode> getChildExps() {
        return this.exps;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        List<RexNode> exps = shuttle.apply(this.exps);
        if (this.exps == exps) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), exps, this.rowType);
    }

    public List<RexNode> getProjects() {
        return this.exps;
    }

    public final List<Pair<RexNode, String>> getNamedProjects() {
        return Pair.zip(this.getProjects(), this.getRowType().getFieldNames());
    }

    @Deprecated
    public int getFlags() {
        return 1;
    }

    @Override
    public boolean isValid(Litmus litmus) {
        if (!super.isValid(litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!RexUtil.compatibleTypes(this.exps, this.getRowType(), litmus)) {
            return litmus.fail("incompatible types", new Object[0]);
        }
        RexChecker checker = new RexChecker(this.getInput().getRowType(), litmus);
        for (RexNode exp : this.exps) {
            exp.accept(checker);
            if (checker.getFailureCount() <= 0) continue;
            return litmus.fail("{} failures in expression {}", checker.getFailureCount(), exp);
        }
        if (!Util.isDistinct(this.rowType.getFieldNames())) {
            return litmus.fail("field names not distinct: {}", this.rowType);
        }
        return litmus.succeed();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this.getInput());
        double dCpu = dRows * (double)this.exps.size();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("fields", this.rowType.getFieldNames());
            pw.item("exprs", this.exps);
        } else {
            for (Ord field : Ord.zip(this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, this.exps.get(field.i));
            }
        }
        if (pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES) {
            // empty if block
        }
        return pw;
    }

    public Mappings.TargetMapping getMapping() {
        return Project.getMapping(this.getInput().getRowType().getFieldCount(), this.exps);
    }

    public static Mappings.TargetMapping getMapping(int inputFieldCount, List<? extends RexNode> projects) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, inputFieldCount, projects.size());
        for (Ord exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) {
                return null;
            }
            mapping.set(((RexInputRef)exp.e).getIndex(), exp.i);
        }
        return mapping;
    }

    public static Mappings.TargetMapping getPartialMapping(int inputFieldCount, List<? extends RexNode> projects) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_FUNCTION, inputFieldCount, projects.size());
        for (Ord exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) continue;
            mapping.set(((RexInputRef)exp.e).getIndex(), exp.i);
        }
        return mapping;
    }

    public Permutation getPermutation() {
        return Project.getPermutation(this.getInput().getRowType().getFieldCount(), this.exps);
    }

    public static Permutation getPermutation(int inputFieldCount, List<? extends RexNode> projects) {
        int fieldCount = projects.size();
        if (fieldCount != inputFieldCount) {
            return null;
        }
        Permutation permutation = new Permutation(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            RexNode exp = projects.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            permutation.set(i, ((RexInputRef)exp).getIndex());
        }
        return permutation;
    }

    public boolean isMapping() {
        for (RexNode exp : this.exps) {
            if (exp instanceof RexInputRef) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static class Flags {
        public static final int ANON_FIELDS = 2;
        public static final int BOXED = 1;
        public static final int NONE = 0;
    }
}

