/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)XmlUtil.class.getName());
    private static final String CONFIGURATION = "configuration";
    private static final String NAME = "name";

    private XmlUtil() {
    }

    static boolean existsIn(URL url, HiveConf.ConfVars confVars) {
        if (url == null) {
            LOG.warn("URL is null or blank");
            return false;
        }
        try {
            Document doc = XmlUtil.readDocument(url);
            return XmlUtil.propertyExists(doc, confVars);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return false;
        }
    }

    private static Document readDocument(URL url) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        return docBuilder.parse(url.getPath());
    }

    @VisibleForTesting
    static boolean propertyExists(Document doc, HiveConf.ConfVars confVars) {
        return XmlUtil.propertyExists(doc, confVars.varname);
    }

    @VisibleForTesting
    static boolean propertyExists(Document doc, String property) {
        Node configuration = XmlUtil.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    static Node getConfigurationNode(Document doc) {
        NodeList nodes = doc.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = nodes.item(i);
            if (!CONFIGURATION.equals(node.getNodeName())) continue;
            return node;
        }
        throw new IllegalArgumentException("No <configuration> tag");
    }
}

