/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Dns;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;

public final class RouteSelector {
    private static final int TLS_MODE_MODERN = 1;
    private static final int TLS_MODE_COMPATIBLE = 0;
    private static final int TLS_MODE_NULL = -1;
    private final Address address;
    private final URI uri;
    private final ProxySelector proxySelector;
    private final ConnectionPool pool;
    private final Dns dns;
    private final Set<Route> failedRoutes;
    private Proxy lastProxy;
    private InetSocketAddress lastInetSocketAddress;
    private boolean hasNextProxy;
    private Proxy userSpecifiedProxy;
    private Iterator<Proxy> proxySelectorProxies;
    private InetAddress[] socketAddresses;
    private int nextSocketAddressIndex;
    private int socketPort;
    private int nextTlsMode = -1;
    private final List<Route> postponedRoutes;

    public RouteSelector(Address address, URI uri, ProxySelector proxySelector, ConnectionPool pool, Dns dns, Set<Route> failedRoutes) {
        this.address = address;
        this.uri = uri;
        this.proxySelector = proxySelector;
        this.pool = pool;
        this.dns = dns;
        this.failedRoutes = failedRoutes;
        this.postponedRoutes = new LinkedList<Route>();
        this.resetNextProxy(uri, address.getProxy());
    }

    public boolean hasNext() {
        return this.hasNextTlsMode() || this.hasNextInetSocketAddress() || this.hasNextProxy() || this.hasNextPostponed();
    }

    public Connection next() throws IOException {
        boolean modernTls;
        Route route;
        Connection pooled = this.pool.get(this.address);
        if (pooled != null) {
            return pooled;
        }
        if (!this.hasNextTlsMode()) {
            if (!this.hasNextInetSocketAddress()) {
                if (!this.hasNextProxy()) {
                    if (!this.hasNextPostponed()) {
                        throw new NoSuchElementException();
                    }
                    return new Connection(this.nextPostponed());
                }
                this.lastProxy = this.nextProxy();
                this.resetNextInetSocketAddress(this.lastProxy);
            }
            this.lastInetSocketAddress = this.nextInetSocketAddress();
            this.resetNextTlsMode();
        }
        if (this.failedRoutes.contains(route = new Route(this.address, this.lastProxy, this.lastInetSocketAddress, modernTls = this.nextTlsMode() == 1))) {
            this.postponedRoutes.add(route);
            return this.next();
        }
        return new Connection(route);
    }

    public void connectFailed(Connection connection, IOException failure) {
        Route failedRoute = connection.getRoute();
        if (failedRoute.getProxy().type() != Proxy.Type.DIRECT && this.proxySelector != null) {
            this.proxySelector.connectFailed(this.uri, failedRoute.getProxy().address(), failure);
        }
        this.failedRoutes.add(failedRoute);
        if (!(failure instanceof SSLHandshakeException)) {
            this.failedRoutes.add(failedRoute.flipTlsMode());
        }
    }

    private void resetNextProxy(URI uri, Proxy proxy) {
        this.hasNextProxy = true;
        if (proxy != null) {
            this.userSpecifiedProxy = proxy;
        } else {
            List<Proxy> proxyList = this.proxySelector.select(uri);
            if (proxyList != null) {
                this.proxySelectorProxies = proxyList.iterator();
            }
        }
    }

    private boolean hasNextProxy() {
        return this.hasNextProxy;
    }

    private Proxy nextProxy() {
        if (this.userSpecifiedProxy != null) {
            this.hasNextProxy = false;
            return this.userSpecifiedProxy;
        }
        if (this.proxySelectorProxies != null) {
            while (this.proxySelectorProxies.hasNext()) {
                Proxy candidate = this.proxySelectorProxies.next();
                if (candidate.type() == Proxy.Type.DIRECT) continue;
                return candidate;
            }
        }
        this.hasNextProxy = false;
        return Proxy.NO_PROXY;
    }

    private void resetNextInetSocketAddress(Proxy proxy) throws UnknownHostException {
        String socketHost;
        this.socketAddresses = null;
        if (proxy.type() == Proxy.Type.DIRECT) {
            socketHost = this.uri.getHost();
            this.socketPort = Util.getEffectivePort(this.uri);
        } else {
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass());
            }
            InetSocketAddress proxySocketAddress = (InetSocketAddress)proxyAddress;
            socketHost = proxySocketAddress.getHostName();
            this.socketPort = proxySocketAddress.getPort();
        }
        this.socketAddresses = this.dns.getAllByName(socketHost);
        this.nextSocketAddressIndex = 0;
    }

    private boolean hasNextInetSocketAddress() {
        return this.socketAddresses != null;
    }

    private InetSocketAddress nextInetSocketAddress() throws UnknownHostException {
        InetSocketAddress result = new InetSocketAddress(this.socketAddresses[this.nextSocketAddressIndex++], this.socketPort);
        if (this.nextSocketAddressIndex == this.socketAddresses.length) {
            this.socketAddresses = null;
            this.nextSocketAddressIndex = 0;
        }
        return result;
    }

    private void resetNextTlsMode() {
        this.nextTlsMode = this.address.getSslSocketFactory() != null ? 1 : 0;
    }

    private boolean hasNextTlsMode() {
        return this.nextTlsMode != -1;
    }

    private int nextTlsMode() {
        if (this.nextTlsMode == 1) {
            this.nextTlsMode = 0;
            return 1;
        }
        if (this.nextTlsMode == 0) {
            this.nextTlsMode = -1;
            return 0;
        }
        throw new AssertionError();
    }

    private boolean hasNextPostponed() {
        return !this.postponedRoutes.isEmpty();
    }

    private Route nextPostponed() {
        return this.postponedRoutes.remove(0);
    }
}

