/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import java.util.Collection;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.util.BaseFieldProjector;
import org.ojai.util.impl.ProjectionTree;

@API.Public
public final class FieldProjector
extends BaseFieldProjector {
    private DocumentReader reader;

    public FieldProjector(String ... includedPaths) {
        super(includedPaths);
    }

    public FieldProjector(FieldPath ... includedPaths) {
        super(includedPaths);
    }

    public FieldProjector(@API.NonNullable Collection<FieldPath> includedPaths) {
        super(includedPaths);
    }

    @Override
    public FieldProjector cloneWithSharedProjectionTree() {
        return new FieldProjector(this.rootSegment);
    }

    public FieldProjector(ProjectionTree rootSegment) {
        super(rootSegment);
    }

    @Override
    public void moveTo(DocumentReader.EventType event) {
        ProjectionTree childSegment = null;
        if (this.currentSegment != null) {
            if (event == DocumentReader.EventType.END_MAP || event == DocumentReader.EventType.END_ARRAY) {
                this.includeField = true;
            } else {
                this.readerFieldSegment.fromReaderField(this.reader);
                childSegment = this.currentSegment.findChild(this.readerFieldSegment);
                this.includeField = this.currentSegment.isSingleValueArray() || childSegment != null && (event == DocumentReader.EventType.START_MAP || event == DocumentReader.EventType.START_ARRAY || childSegment.isLeafSegment() || childSegment.isSingleValueArray());
            }
        }
        switch (event) {
            case START_MAP: 
            case START_ARRAY: {
                if (!this.shouldEmitEvent()) break;
                if (this.currentSegment != null) {
                    this.currentSegment = childSegment;
                    if (childSegment == null) break;
                    this.lastSegment = childSegment;
                    this.includeAllChildren = childSegment.isLeafSegment();
                    if (!this.includeAllChildren) break;
                    this.level = 1;
                    this.currentSegment = null;
                    break;
                }
                ++this.level;
                break;
            }
            case END_MAP: 
            case END_ARRAY: {
                if (!this.shouldEmitEvent()) break;
                if (this.currentSegment == null) {
                    --this.level;
                    if (this.level != 0) break;
                    this.currentSegment = this.lastSegment.getParent();
                    this.includeAllChildren = false;
                    break;
                }
                this.currentSegment = this.currentSegment.getParent();
                break;
            }
        }
    }

    @Override
    public FieldProjector reset(DocumentReader reader) {
        this.reader = reader;
        this.currentSegment = this.rootSegment;
        return this;
    }
}

