/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.IAE;
import io.druid.segment.CompressedVSizeIndexedSupplier;
import io.druid.segment.CompressedVSizeIndexedV3Supplier;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerde;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferSerializer;
import io.druid.segment.data.ByteBufferWriter;
import io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIntsWriter;
import io.druid.segment.data.IndexedMultivalue;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import io.druid.segment.data.WritableSupplier;
import io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    private static final int NO_FLAGS = 0;
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ColumnPartSerde.Serializer serializer;

    @JsonCreator
    public static DictionaryEncodedColumnPartSerde createDeserializer(@Nullable @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory, @NotNull @JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DictionaryEncodedColumnPartSerde(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private DictionaryEncodedColumnPartSerde(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ColumnPartSerde.Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    public static LegacySerializerBuilder legacySerializerBuilder() {
        return new LegacySerializerBuilder();
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                WritableSupplier<IndexedInts> rSingleValuedColumn;
                WritableSupplier<IndexedMultivalue<IndexedInts>> rMultiValuedColumn;
                VERSION rVersion = VERSION.fromByte(buffer.get());
                int rFlags = rVersion.compareTo(VERSION.COMPRESSED) >= 0 ? buffer.getInt() : (rVersion.equals((Object)VERSION.UNCOMPRESSED_MULTI_VALUE) ? Feature.MULTI_VALUE.getMask() : 0);
                boolean hasMultipleValues = Feature.MULTI_VALUE.isSet(rFlags) || Feature.MULTI_VALUE_V3.isSet(rFlags);
                GenericIndexed<String> rDictionary = GenericIndexed.read(buffer, GenericIndexed.STRING_STRATEGY);
                builder.setType(ValueType.STRING);
                if (hasMultipleValues) {
                    rMultiValuedColumn = this.readMultiValuedColum(rVersion, buffer, rFlags);
                    rSingleValuedColumn = null;
                } else {
                    rSingleValuedColumn = this.readSingleValuedColumn(rVersion, buffer);
                    rMultiValuedColumn = null;
                }
                builder.setHasMultipleValues(hasMultipleValues).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(rDictionary, rSingleValuedColumn, rMultiValuedColumn, columnConfig.columnCacheSizeBytes()));
                GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(buffer, DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getObjectStrategy());
                builder.setBitmapIndex(new BitmapIndexColumnPartSupplier(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory(), rBitmaps, rDictionary));
                ImmutableRTree rSpatialIndex = null;
                if (buffer.hasRemaining()) {
                    rSpatialIndex = ByteBufferSerializer.read(buffer, new IndexedRTree.ImmutableRTreeObjectStrategy(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory()));
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(rSpatialIndex));
                }
            }

            private WritableSupplier<IndexedInts> readSingleValuedColumn(VERSION version, ByteBuffer buffer) {
                switch (version) {
                    case UNCOMPRESSED_SINGLE_VALUE: {
                        return VSizeIndexedInts.readFromByteBuffer(buffer).asWritableSupplier();
                    }
                    case COMPRESSED: {
                        return CompressedVSizeIntsIndexedSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                    }
                }
                throw new IAE("Unsupported single-value version[%s]", new Object[]{version});
            }

            private WritableSupplier<IndexedMultivalue<IndexedInts>> readMultiValuedColum(VERSION version, ByteBuffer buffer, int flags) {
                switch (version) {
                    case UNCOMPRESSED_MULTI_VALUE: {
                        return VSizeIndexed.readFromByteBuffer(buffer).asWritableSupplier();
                    }
                    case COMPRESSED: {
                        if (Feature.MULTI_VALUE.isSet(flags)) {
                            return CompressedVSizeIndexedSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                        }
                        if (Feature.MULTI_VALUE_V3.isSet(flags)) {
                            return CompressedVSizeIndexedV3Supplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                        }
                        throw new IAE("Unrecognized multi-value flag[%d]", new Object[]{flags});
                    }
                }
                throw new IAE("Unsupported multi-value version[%s]", new Object[]{version});
            }
        };
    }

    public static class LegacySerializerBuilder {
        private VERSION version = null;
        private int flags = 0;
        private GenericIndexed<String> dictionary = null;
        private WritableSupplier<IndexedInts> singleValuedColumn = null;
        private WritableSupplier<IndexedMultivalue<IndexedInts>> multiValuedColumn = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;
        private GenericIndexed<ImmutableBitmap> bitmaps = null;
        private ImmutableRTree spatialIndex = null;
        private ByteOrder byteOrder = null;

        private LegacySerializerBuilder() {
        }

        public LegacySerializerBuilder withDictionary(GenericIndexed<String> dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public LegacySerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public LegacySerializerBuilder withBitmaps(GenericIndexed<ImmutableBitmap> bitmaps) {
            this.bitmaps = bitmaps;
            return this;
        }

        public LegacySerializerBuilder withSpatialIndex(ImmutableRTree spatialIndex) {
            this.spatialIndex = spatialIndex;
            return this;
        }

        public LegacySerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public LegacySerializerBuilder withSingleValuedColumn(VSizeIndexedInts singleValuedColumn) {
            Preconditions.checkState((this.multiValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both singleValuedColumn and multiValuedColumn");
            this.version = VERSION.UNCOMPRESSED_SINGLE_VALUE;
            this.singleValuedColumn = singleValuedColumn.asWritableSupplier();
            return this;
        }

        public LegacySerializerBuilder withSingleValuedColumn(CompressedVSizeIntsIndexedSupplier singleValuedColumn) {
            Preconditions.checkState((this.multiValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both singleValuedColumn and multiValuedColumn");
            this.version = VERSION.COMPRESSED;
            this.singleValuedColumn = singleValuedColumn;
            return this;
        }

        public LegacySerializerBuilder withMultiValuedColumn(VSizeIndexed multiValuedColumn) {
            Preconditions.checkState((this.singleValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both multiValuedColumn and singleValuedColumn");
            this.version = VERSION.UNCOMPRESSED_MULTI_VALUE;
            this.flags |= Feature.MULTI_VALUE.getMask();
            this.multiValuedColumn = multiValuedColumn.asWritableSupplier();
            return this;
        }

        public LegacySerializerBuilder withMultiValuedColumn(CompressedVSizeIndexedSupplier multiValuedColumn) {
            Preconditions.checkState((this.singleValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both singleValuedColumn and multiValuedColumn");
            this.version = VERSION.COMPRESSED;
            this.flags |= Feature.MULTI_VALUE.getMask();
            this.multiValuedColumn = multiValuedColumn;
            return this;
        }

        public DictionaryEncodedColumnPartSerde build() {
            Preconditions.checkArgument((boolean)(this.singleValuedColumn != null ^ this.multiValuedColumn != null), (String)"Exactly one of singleValCol[%s] or multiValCol[%s] must be set", (Object[])new Object[]{this.singleValuedColumn, this.multiValuedColumn});
            return new DictionaryEncodedColumnPartSerde(this.byteOrder, this.bitmapSerdeFactory, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    long size = 1 + (LegacySerializerBuilder.this.version.compareTo(VERSION.COMPRESSED) >= 0 ? 4 : 0);
                    size += LegacySerializerBuilder.this.dictionary.getSerializedSize();
                    size = Feature.MULTI_VALUE.isSet(LegacySerializerBuilder.this.flags) ? (size += LegacySerializerBuilder.this.multiValuedColumn.getSerializedSize()) : (size += LegacySerializerBuilder.this.singleValuedColumn.getSerializedSize());
                    size += LegacySerializerBuilder.this.bitmaps.getSerializedSize();
                    if (LegacySerializerBuilder.this.spatialIndex != null) {
                        size += (long)(LegacySerializerBuilder.this.spatialIndex.size() + 4);
                    }
                    return size;
                }

                @Override
                public void write(WritableByteChannel channel) throws IOException {
                    channel.write(ByteBuffer.wrap(new byte[]{LegacySerializerBuilder.this.version.asByte()}));
                    if (LegacySerializerBuilder.this.version.compareTo(VERSION.COMPRESSED) >= 0) {
                        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)LegacySerializerBuilder.this.flags)));
                    }
                    if (LegacySerializerBuilder.this.dictionary != null) {
                        LegacySerializerBuilder.this.dictionary.writeToChannel(channel);
                    }
                    if (Feature.MULTI_VALUE.isSet(LegacySerializerBuilder.this.flags)) {
                        if (LegacySerializerBuilder.this.multiValuedColumn != null) {
                            LegacySerializerBuilder.this.multiValuedColumn.writeToChannel(channel);
                        }
                    } else if (LegacySerializerBuilder.this.singleValuedColumn != null) {
                        LegacySerializerBuilder.this.singleValuedColumn.writeToChannel(channel);
                    }
                    if (LegacySerializerBuilder.this.bitmaps != null) {
                        LegacySerializerBuilder.this.bitmaps.writeToChannel(channel);
                    }
                    if (LegacySerializerBuilder.this.spatialIndex != null) {
                        ByteBufferSerializer.writeToChannel(LegacySerializerBuilder.this.spatialIndex, new IndexedRTree.ImmutableRTreeObjectStrategy(LegacySerializerBuilder.this.bitmapSerdeFactory.getBitmapFactory()), channel);
                    }
                }
            });
        }
    }

    public static class SerializerBuilder {
        private VERSION version = null;
        private int flags = 0;
        private GenericIndexedWriter<String> dictionaryWriter = null;
        private IndexedIntsWriter valueWriter = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;
        private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = null;
        private ByteBufferWriter<ImmutableRTree> spatialIndexWriter = null;
        private ByteOrder byteOrder = null;

        public SerializerBuilder withDictionary(GenericIndexedWriter<String> dictionaryWriter) {
            this.dictionaryWriter = dictionaryWriter;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public SerializerBuilder withBitmapIndex(GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter) {
            this.bitmapIndexWriter = bitmapIndexWriter;
            return this;
        }

        public SerializerBuilder withSpatialIndex(ByteBufferWriter<ImmutableRTree> spatialIndexWriter) {
            this.spatialIndexWriter = spatialIndexWriter;
            return this;
        }

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withValue(IndexedIntsWriter valueWriter, boolean hasMultiValue, boolean compressed) {
            this.valueWriter = valueWriter;
            if (hasMultiValue) {
                if (compressed) {
                    this.version = VERSION.COMPRESSED;
                    this.flags |= Feature.MULTI_VALUE_V3.getMask();
                } else {
                    this.version = VERSION.UNCOMPRESSED_MULTI_VALUE;
                    this.flags |= Feature.MULTI_VALUE.getMask();
                }
            } else {
                this.version = compressed ? VERSION.COMPRESSED : VERSION.UNCOMPRESSED_SINGLE_VALUE;
            }
            return this;
        }

        public DictionaryEncodedColumnPartSerde build() {
            return new DictionaryEncodedColumnPartSerde(this.byteOrder, this.bitmapSerdeFactory, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    long size = 1 + (SerializerBuilder.this.version.compareTo(VERSION.COMPRESSED) >= 0 ? 4 : 0);
                    if (SerializerBuilder.this.dictionaryWriter != null) {
                        size += SerializerBuilder.this.dictionaryWriter.getSerializedSize();
                    }
                    if (SerializerBuilder.this.valueWriter != null) {
                        size += SerializerBuilder.this.valueWriter.getSerializedSize();
                    }
                    if (SerializerBuilder.this.bitmapIndexWriter != null) {
                        size += SerializerBuilder.this.bitmapIndexWriter.getSerializedSize();
                    }
                    if (SerializerBuilder.this.spatialIndexWriter != null) {
                        size += SerializerBuilder.this.spatialIndexWriter.getSerializedSize();
                    }
                    return size;
                }

                @Override
                public void write(WritableByteChannel channel) throws IOException {
                    channel.write(ByteBuffer.wrap(new byte[]{SerializerBuilder.this.version.asByte()}));
                    if (SerializerBuilder.this.version.compareTo(VERSION.COMPRESSED) >= 0) {
                        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)SerializerBuilder.this.flags)));
                    }
                    if (SerializerBuilder.this.dictionaryWriter != null) {
                        SerializerBuilder.this.dictionaryWriter.writeToChannel(channel);
                    }
                    if (SerializerBuilder.this.valueWriter != null) {
                        SerializerBuilder.this.valueWriter.writeToChannel(channel);
                    }
                    if (SerializerBuilder.this.bitmapIndexWriter != null) {
                        SerializerBuilder.this.bitmapIndexWriter.writeToChannel(channel);
                    }
                    if (SerializerBuilder.this.spatialIndexWriter != null) {
                        SerializerBuilder.this.spatialIndexWriter.writeToChannel(channel);
                    }
                }
            });
        }
    }

    static enum VERSION {
        UNCOMPRESSED_SINGLE_VALUE,
        UNCOMPRESSED_MULTI_VALUE,
        COMPRESSED;


        public static VERSION fromByte(byte b) {
            VERSION[] values = VERSION.values();
            Preconditions.checkArgument((b < values.length ? 1 : 0) != 0, (String)"Unsupported dictionary column version[%s]", (Object[])new Object[]{b});
            return values[b];
        }

        public byte asByte() {
            return (byte)this.ordinal();
        }
    }

    static enum Feature {
        MULTI_VALUE,
        MULTI_VALUE_V3;


        public boolean isSet(int flags) {
            return (this.getMask() & flags) != 0;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

