/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import java.util.Arrays;
import java.util.Set;

public class IndexSpec {
    public static final CompressedObjectStrategy.CompressionStrategy DEFAULT_METRIC_COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressedObjectStrategy.CompressionStrategy DEFAULT_DIMENSION_COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressionFactory.LongEncodingStrategy DEFAULT_LONG_ENCODING = CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY;
    private static final Set<CompressedObjectStrategy.CompressionStrategy> METRIC_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressedObjectStrategy.CompressionStrategy.values()));
    private static final Set<CompressedObjectStrategy.CompressionStrategy> DIMENSION_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressedObjectStrategy.CompressionStrategy.noNoneValues()));
    private static final Set<CompressionFactory.LongEncodingStrategy> LONG_ENCODING_NAMES = Sets.newHashSet(Arrays.asList(CompressionFactory.LongEncodingStrategy.values()));
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final CompressedObjectStrategy.CompressionStrategy dimensionCompression;
    private final CompressedObjectStrategy.CompressionStrategy metricCompression;
    private final CompressionFactory.LongEncodingStrategy longEncoding;

    public IndexSpec() {
        this(null, null, null, null);
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") CompressedObjectStrategy.CompressionStrategy dimensionCompression, @JsonProperty(value="metricCompression") CompressedObjectStrategy.CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") CompressionFactory.LongEncodingStrategy longEncoding) {
        Preconditions.checkArgument((dimensionCompression == null || DIMENSION_COMPRESSION.contains((Object)dimensionCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{dimensionCompression});
        Preconditions.checkArgument((metricCompression == null || METRIC_COMPRESSION.contains((Object)metricCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{metricCompression});
        Preconditions.checkArgument((longEncoding == null || LONG_ENCODING_NAMES.contains((Object)longEncoding) ? 1 : 0) != 0, (String)"Unknown long encoding type[%s]", (Object[])new Object[]{longEncoding});
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : new ConciseBitmapSerdeFactory();
        this.dimensionCompression = dimensionCompression == null ? DEFAULT_DIMENSION_COMPRESSION : dimensionCompression;
        this.metricCompression = metricCompression == null ? DEFAULT_METRIC_COMPRESSION : metricCompression;
        this.longEncoding = longEncoding == null ? DEFAULT_LONG_ENCODING : longEncoding;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public CompressedObjectStrategy.CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    public CompressedObjectStrategy.CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        if (this.bitmapSerdeFactory != null ? !this.bitmapSerdeFactory.equals(indexSpec.bitmapSerdeFactory) : indexSpec.bitmapSerdeFactory != null) {
            return false;
        }
        if (this.dimensionCompression != null ? !this.dimensionCompression.equals((Object)indexSpec.dimensionCompression) : indexSpec.dimensionCompression != null) {
            return false;
        }
        return !(this.metricCompression == null ? indexSpec.metricCompression != null : !this.metricCompression.equals((Object)indexSpec.metricCompression));
    }

    public int hashCode() {
        int result = this.bitmapSerdeFactory != null ? this.bitmapSerdeFactory.hashCode() : 0;
        result = 31 * result + (this.dimensionCompression != null ? this.dimensionCompression.hashCode() : 0);
        result = 31 * result + (this.metricCompression != null ? this.metricCompression.hashCode() : 0);
        return result;
    }
}

