/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.StringUtils;
import io.druid.query.lookup.LookupExtractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="map")
public class MapLookupExtractor
extends LookupExtractor {
    private final Map<String, String> map;
    private final boolean isOneToOne;

    @JsonCreator
    public MapLookupExtractor(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = (Map)Preconditions.checkNotNull(map, (Object)"map");
        this.isOneToOne = isOneToOne;
    }

    @JsonProperty
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    @Override
    @Nullable
    public String apply(@NotNull String val) {
        return this.map.get(val);
    }

    @Override
    public List<String> unapply(final String value) {
        return Lists.newArrayList(Maps.filterKeys(this.map, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String key) {
                return ((String)MapLookupExtractor.this.map.get(key)).equals(Strings.nullToEmpty((String)value));
            }
        }).keySet());
    }

    @Override
    @JsonProperty(value="isOneToOne")
    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!Strings.isNullOrEmpty((String)key)) {
                    outputStream.write(StringUtils.toUtf8((String)key));
                }
                outputStream.write(-1);
                if (!Strings.isNullOrEmpty((String)val)) {
                    outputStream.write(StringUtils.toUtf8((String)val));
                }
                outputStream.write(-1);
            }
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractor that = (MapLookupExtractor)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

