/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.LongSumAggregator;
import io.druid.segment.LongColumnSelector;
import java.util.Comparator;

public class LongMaxAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private final LongColumnSelector selector;
    private final String name;
    private long max;

    static long combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMaxAggregator(String name, LongColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.get());
    }

    @Override
    public void reset() {
        this.max = Long.MIN_VALUE;
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return this.max;
    }

    @Override
    public long getLong() {
        return this.max;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new LongMaxAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

