/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import io.druid.query.QueryToolChest;
import io.druid.query.aggregation.AggregatorFactory;
import java.util.List;
import org.joda.time.Interval;

public class DruidMetrics {
    public static final String DATASOURCE = "dataSource";
    public static final String TYPE = "type";
    public static final String INTERVAL = "interval";
    public static final String ID = "id";
    public static final String TASK_ID = "taskId";
    public static final String STATUS = "status";
    public static final String VERSION = "version";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER = "server";
    public static final String TIER = "tier";

    public static int findNumComplexAggs(List<AggregatorFactory> aggs) {
        int retVal = 0;
        for (AggregatorFactory agg : aggs) {
            if (agg.getTypeName().equals("float") || agg.getTypeName().equals("long")) continue;
            ++retVal;
        }
        return retVal;
    }

    public static <T> ServiceMetricEvent.Builder makePartialQueryTimeMetric(Query<T> query) {
        return new ServiceMetricEvent.Builder().setDimension(VERSION, Strings.nullToEmpty((String)DruidMetrics.class.getPackage().getImplementationVersion())).setDimension(DATASOURCE, DataSourceUtil.getMetricName(query.getDataSource())).setDimension(TYPE, query.getType()).setDimension(INTERVAL, Lists.transform(query.getIntervals(), (Function)new Function<Interval, String>(){

            public String apply(Interval input) {
                return input.toString();
            }
        }).toArray(new String[query.getIntervals().size()])).setDimension("hasFilters", String.valueOf(query.hasFilters())).setDimension("duration", query.getDuration().toString()).setDimension(ID, Strings.nullToEmpty((String)query.getId()));
    }

    public static <T> ServiceMetricEvent.Builder makeQueryTimeMetric(QueryToolChest<T, Query<T>> toolChest, ObjectMapper jsonMapper, Query<T> query, String remoteAddr) throws JsonProcessingException {
        ServiceMetricEvent.Builder baseMetric = toolChest == null ? DruidMetrics.makePartialQueryTimeMetric(query) : toolChest.makeMetricBuilder(query);
        return baseMetric.setDimension("context", jsonMapper.writeValueAsString(query.getContext() == null ? ImmutableMap.of() : query.getContext())).setDimension("remoteAddress", remoteAddr);
    }
}

