/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;

public class WholeRowIterator
implements SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> sourceIter;
    private Key topKey = null;
    private Value topValue = null;
    List<Key> keys = new ArrayList<Key>();
    List<Value> values = new ArrayList<Value>();

    public WholeRowIterator() {
    }

    WholeRowIterator(SortedKeyValueIterator<Key, Value> source) {
        this.sourceIter = source;
    }

    private static byte[] readField(DataInputStream din) throws IOException {
        int len = din.readInt();
        byte[] b = new byte[len];
        int readLen = din.read(b);
        if (len > 0 && len != readLen) {
            throw new IOException(String.format("Expected to read %d bytes but read %d", len, readLen));
        }
        return b;
    }

    public static final SortedMap<Key, Value> decodeRow(Key rowKey, Value rowValue) throws IOException {
        TreeMap<Key, Value> map = new TreeMap<Key, Value>();
        ByteArrayInputStream in = new ByteArrayInputStream(rowValue.get());
        DataInputStream din = new DataInputStream(in);
        int numKeys = din.readInt();
        for (int i = 0; i < numKeys; ++i) {
            byte[] cf = WholeRowIterator.readField(din);
            byte[] cq = WholeRowIterator.readField(din);
            byte[] cv = WholeRowIterator.readField(din);
            long timestamp = din.readLong();
            byte[] valBytes = WholeRowIterator.readField(din);
            map.put(new Key(rowKey.getRowData().toArray(), cf, cq, cv, timestamp, false, false), new Value(valBytes, false));
        }
        return map;
    }

    public static final Value encodeRow(List<Key> keys, List<Value> values) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            Key k = keys.get(i);
            Value v = values.get(i);
            ByteSequence bs = k.getColumnFamilyData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            bs = k.getColumnQualifierData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            bs = k.getColumnVisibilityData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            dout.writeLong(k.getTimestamp());
            byte[] valBytes = v.get();
            dout.writeInt(valBytes.length);
            dout.write(valBytes);
        }
        return new Value(out.toByteArray());
    }

    private void prepKeys() throws IOException {
        Text currentRow;
        if (this.topKey != null) {
            return;
        }
        do {
            if (!this.sourceIter.hasTop()) {
                return;
            }
            currentRow = new Text(this.sourceIter.getTopKey().getRow());
            this.keys.clear();
            this.values.clear();
            while (this.sourceIter.hasTop() && this.sourceIter.getTopKey().getRow().equals((Object)currentRow)) {
                this.keys.add(new Key(this.sourceIter.getTopKey()));
                this.values.add(new Value(this.sourceIter.getTopValue()));
                this.sourceIter.next();
            }
        } while (!this.filter(currentRow, this.keys, this.values));
        this.topKey = new Key(currentRow);
        this.topValue = WholeRowIterator.encodeRow(this.keys, this.values);
    }

    protected boolean filter(Text currentRow, List<Key> keys, List<Value> values) {
        return true;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        if (this.sourceIter != null) {
            return new WholeRowIterator(this.sourceIter.deepCopy(env));
        }
        return new WholeRowIterator();
    }

    @Override
    public Key getTopKey() {
        return this.topKey;
    }

    @Override
    public Value getTopValue() {
        return this.topValue;
    }

    @Override
    public boolean hasTop() {
        return this.topKey != null;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.sourceIter = source;
    }

    @Override
    public void next() throws IOException {
        this.topKey = null;
        this.topValue = null;
        this.prepKeys();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.topKey = null;
        this.topValue = null;
        Key sk = range.getStartKey();
        if (sk != null && sk.getColumnFamilyData().length() == 0 && sk.getColumnQualifierData().length() == 0 && sk.getColumnVisibilityData().length() == 0 && sk.getTimestamp() == Long.MAX_VALUE && !range.isStartKeyInclusive()) {
            Key followingRowKey = sk.followingKey(PartialKey.ROW);
            if (range.getEndKey() != null && followingRowKey.compareTo(range.getEndKey()) > 0) {
                return;
            }
            range = new Range(sk.followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
        }
        this.sourceIter.seek(range, columnFamilies, inclusive);
        this.prepKeys();
    }
}

