/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class PrintInfo {
    private static final Logger log = Logger.getLogger(PrintInfo.class);

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        AccumuloConfiguration aconf = AccumuloConfiguration.getSiteConfiguration();
        FileSystem hadoopFs = VolumeConfiguration.getDefaultVolume(conf, aconf).getFileSystem();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Opts opts = new Opts();
        opts.parseArgs(PrintInfo.class.getName(), args, new Object[0]);
        if (opts.files.isEmpty()) {
            System.err.println("No files were given");
            System.exit(-1);
        }
        long[] countBuckets = new long[11];
        long[] sizeBuckets = new long[countBuckets.length];
        long totalSize = 0L;
        for (String arg : opts.files) {
            FileSystem fs;
            Path path = new Path(arg);
            if (arg.contains(":")) {
                fs = path.getFileSystem(conf);
            } else {
                log.warn((Object)"Attempting to find file across filesystems. Consider providing URI instead of path");
                fs = hadoopFs.exists(path) ? hadoopFs : localFs;
            }
            CachableBlockFile.Reader _rdr = new CachableBlockFile.Reader(fs, path, conf, null, null, aconf);
            RFile.Reader iter = new RFile.Reader(_rdr);
            iter.printInfo();
            System.out.println();
            org.apache.accumulo.core.file.rfile.bcfile.PrintInfo.main(new String[]{arg});
            if (opts.histogram || opts.dump) {
                iter.seek(new Range((Key)null, (Key)null), new ArrayList<ByteSequence>(), false);
                while (iter.hasTop()) {
                    Key key = iter.getTopKey();
                    Value value = iter.getTopValue();
                    if (opts.dump) {
                        System.out.println(key + " -> " + value);
                    }
                    if (opts.histogram) {
                        int bucket;
                        long size = key.getSize() + value.getSize();
                        int n = bucket = (int)Math.log10(size);
                        countBuckets[n] = countBuckets[n] + 1L;
                        int n2 = bucket;
                        sizeBuckets[n2] = sizeBuckets[n2] + size;
                        totalSize += size;
                    }
                    iter.next();
                }
            }
            iter.close();
            if (opts.histogram) {
                System.out.println("Up to size      count      %-age");
                for (int i = 1; i < countBuckets.length; ++i) {
                    System.out.println(String.format("%11.0f : %10d %6.2f%%", Math.pow(10.0, i), countBuckets[i], (double)sizeBuckets[i] * 100.0 / (double)totalSize));
                }
            }
            if (!System.out.checkError()) continue;
            return;
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-d", "--dump"}, description="dump the key/value pairs")
        boolean dump = false;
        @Parameter(names={"--histogram"}, description="print a histogram of the key-value sizes")
        boolean histogram = false;
        @Parameter(description=" <file> { <file> ... }")
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }
}

