/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveRelOptUtil
extends RelOptUtil {
    private static final Log LOG = LogFactory.getLog(HiveRelOptUtil.class);

    public static RexNode splitHiveJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) throws CalciteSemanticException {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        HiveRelOptUtil.splitJoinCondition(sysFieldList, inputs, condition, joinKeys, filterNulls, rangeOp, nonEquiList);
        return RexUtil.composeConjunction((RexBuilder)inputs.get(0).getCluster().getRexBuilder(), nonEquiList, (boolean)false);
    }

    private static void splitJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp, List<RexNode> nonEquiList) throws CalciteSemanticException {
        int sysFieldCount = sysFieldList.size();
        RelOptCluster cluster = inputs.get(0).getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableBitSet[] inputsRange = new ImmutableBitSet[inputs.size()];
        int totalFieldCount = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            int firstField = totalFieldCount + sysFieldCount;
            totalFieldCount = firstField + inputs.get(i).getRowType().getFieldCount();
            inputsRange[i] = ImmutableBitSet.range((int)firstField, (int)totalFieldCount);
        }
        int[] adjustments = new int[totalFieldCount];
        for (int i = 0; i < inputs.size(); ++i) {
            int adjustment;
            for (int j = adjustment = inputsRange[i].nextSetBit(0); j < inputsRange[i].length(); ++j) {
                adjustments[j] = -adjustment;
            }
        }
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    HiveRelOptUtil.splitJoinCondition(sysFieldList, inputs, operand, joinKeys, filterNulls, rangeOp, nonEquiList);
                }
                return;
            }
            RexNode leftKey = null;
            RexNode rightKey = null;
            int leftInput = 0;
            int rightInput = 0;
            List leftFields = null;
            List rightFields = null;
            boolean reverse = false;
            SqlKind kind = call.getKind();
            if (kind == SqlKind.EQUALS || filterNulls != null && kind == SqlKind.IS_NOT_DISTINCT_FROM || rangeOp != null && rangeOp.isEmpty() && (kind == SqlKind.GREATER_THAN || kind == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL)) {
                List operands = call.getOperands();
                RexNode op0 = (RexNode)operands.get(0);
                RexNode op1 = (RexNode)operands.get(1);
                ImmutableBitSet projRefs0 = RelOptUtil.InputFinder.bits((RexNode)op0);
                ImmutableBitSet projRefs1 = RelOptUtil.InputFinder.bits((RexNode)op1);
                boolean foundBothInputs = false;
                for (int i = 0; i < inputs.size() && !foundBothInputs; ++i) {
                    if (projRefs0.intersects(inputsRange[i]) && projRefs0.union(inputsRange[i]).equals((Object)inputsRange[i])) {
                        if (leftKey == null) {
                            leftKey = op0;
                            leftInput = i;
                            leftFields = inputs.get(leftInput).getRowType().getFieldList();
                            continue;
                        }
                        rightKey = op0;
                        rightInput = i;
                        rightFields = inputs.get(rightInput).getRowType().getFieldList();
                        reverse = true;
                        foundBothInputs = true;
                        continue;
                    }
                    if (!projRefs1.intersects(inputsRange[i]) || !projRefs1.union(inputsRange[i]).equals((Object)inputsRange[i])) continue;
                    if (leftKey == null) {
                        leftKey = op1;
                        leftInput = i;
                        leftFields = inputs.get(leftInput).getRowType().getFieldList();
                        continue;
                    }
                    rightKey = op1;
                    rightInput = i;
                    rightFields = inputs.get(rightInput).getRowType().getFieldList();
                    foundBothInputs = true;
                }
                if (leftKey != null && rightKey != null) {
                    RelDataType rightKeyType;
                    rightKey = (RexNode)rightKey.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, rightFields, rightFields, adjustments));
                    RelDataType leftKeyType = (leftKey = (RexNode)leftKey.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, leftFields, leftFields, adjustments))).getType();
                    if (leftKeyType != (rightKeyType = rightKey.getType())) {
                        TypeInfo rType = TypeConverter.convert(rightKeyType);
                        TypeInfo lType = TypeConverter.convert(leftKeyType);
                        TypeInfo tgtType = FunctionRegistry.getCommonClassForComparison(lType, rType);
                        if (tgtType == null) {
                            throw new CalciteSemanticException("Cannot find common type for join keys " + leftKey + " (type " + leftKeyType + ") and " + rightKey + " (type " + rightKeyType + ")");
                        }
                        RelDataType targetKeyType = TypeConverter.convert(tgtType, rexBuilder.getTypeFactory());
                        if (leftKeyType != targetKeyType && TypeInfoUtils.isConversionRequiredForComparison(tgtType, lType)) {
                            leftKey = rexBuilder.makeCast(targetKeyType, leftKey);
                        }
                        if (rightKeyType != targetKeyType && TypeInfoUtils.isConversionRequiredForComparison(tgtType, rType)) {
                            rightKey = rexBuilder.makeCast(targetKeyType, rightKey);
                        }
                    }
                }
            }
            if (leftKey != null && rightKey != null) {
                HiveRelOptUtil.addJoinKey(joinKeys.get(leftInput), leftKey, rangeOp != null && !rangeOp.isEmpty());
                HiveRelOptUtil.addJoinKey(joinKeys.get(rightInput), rightKey, rangeOp != null && !rangeOp.isEmpty());
                if (filterNulls != null && kind == SqlKind.EQUALS) {
                    filterNulls.add(joinKeys.get(leftInput).size() - 1);
                }
                if (rangeOp != null && kind != SqlKind.EQUALS && kind != SqlKind.IS_DISTINCT_FROM) {
                    if (reverse) {
                        kind = HiveRelOptUtil.reverse(kind);
                    }
                    rangeOp.add(HiveRelOptUtil.op(kind, call.getOperator()));
                }
                return;
            }
        }
        nonEquiList.add(condition);
    }

    private static SqlKind reverse(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return kind;
    }

    private static SqlOperator op(SqlKind kind, SqlOperator operator) {
        switch (kind) {
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
            }
        }
        return operator;
    }

    private static void addJoinKey(List<RexNode> joinKeyList, RexNode key, boolean preserveLastElementInList) {
        if (!joinKeyList.isEmpty() && preserveLastElementInList) {
            joinKeyList.add(joinKeyList.size() - 1, key);
        } else {
            joinKeyList.add(key);
        }
    }
}

