/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.thrift.TException;

public class HiveMetaStoreChecker {
    public static final Log LOG = LogFactory.getLog(HiveMetaStoreChecker.class);
    private final Hive hive;
    private final HiveConf conf;

    public HiveMetaStoreChecker(Hive hive) {
        this.hive = hive;
        this.conf = hive.getConf();
    }

    public void checkMetastore(String dbName, String tableName, List<? extends Map<String, String>> partitions, CheckResult result) throws HiveException, IOException {
        if (dbName == null || "".equalsIgnoreCase(dbName)) {
            dbName = "default";
        }
        try {
            if (tableName == null || "".equals(tableName)) {
                List<String> tables = this.hive.getTablesForDb(dbName, ".*");
                for (String currentTableName : tables) {
                    this.checkTable(dbName, currentTableName, null, result);
                }
                this.findUnknownTables(dbName, tables, result);
            } else if (partitions == null || partitions.isEmpty()) {
                this.checkTable(dbName, tableName, null, result);
            } else {
                this.checkTable(dbName, tableName, partitions, result);
            }
            Collections.sort(result.getPartitionsNotInMs());
            Collections.sort(result.getPartitionsNotOnFs());
            Collections.sort(result.getTablesNotInMs());
            Collections.sort(result.getTablesNotOnFs());
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    void findUnknownTables(String dbName, List<String> tables, CheckResult result) throws IOException, MetaException, TException, HiveException {
        HashSet<Path> dbPaths = new HashSet<Path>();
        HashSet<String> tableNames = new HashSet<String>(tables);
        for (String tableName : tables) {
            Table table = this.hive.getTable(dbName, tableName);
            String isExternal = table.getParameters().get("EXTERNAL");
            if (isExternal != null && "TRUE".equalsIgnoreCase(isExternal)) continue;
            dbPaths.add(table.getPath().getParent());
        }
        for (Path dbPath : dbPaths) {
            FileStatus[] statuses;
            FileSystem fs = dbPath.getFileSystem((Configuration)this.conf);
            for (FileStatus status : statuses = fs.listStatus(dbPath, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (!status.isDir() || tableNames.contains(status.getPath().getName())) continue;
                result.getTablesNotInMs().add(status.getPath().getName());
            }
        }
    }

    void checkTable(String dbName, String tableName, List<? extends Map<String, String>> partitions, CheckResult result) throws MetaException, IOException, HiveException {
        Table table = null;
        try {
            table = this.hive.getTable(dbName, tableName);
        }
        catch (HiveException e) {
            result.getTablesNotInMs().add(tableName);
            return;
        }
        List<Partition> parts = new ArrayList<Partition>();
        boolean findUnknownPartitions = true;
        if (table.isPartitioned()) {
            if (partitions == null || partitions.isEmpty()) {
                parts = this.hive.getPartitions(table);
            } else {
                findUnknownPartitions = false;
                for (Map<String, String> map : partitions) {
                    Partition part = this.hive.getPartition(table, map, false);
                    if (part == null) {
                        CheckResult.PartitionResult pr = new CheckResult.PartitionResult();
                        pr.setTableName(tableName);
                        pr.setPartitionName(Warehouse.makePartPath(map));
                        result.getPartitionsNotInMs().add(pr);
                        continue;
                    }
                    parts.add(part);
                }
            }
        }
        this.checkTable(table, parts, findUnknownPartitions, result);
    }

    void checkTable(Table table, List<Partition> parts, boolean findUnknownPartitions, CheckResult result) throws IOException, HiveException {
        Path tablePath = table.getPath();
        FileSystem fs = tablePath.getFileSystem((Configuration)this.conf);
        if (!fs.exists(tablePath)) {
            result.getTablesNotOnFs().add(table.getTableName());
            return;
        }
        HashSet<Path> partPaths = new HashSet<Path>();
        for (Partition partition : parts) {
            if (partition == null) continue;
            Path partPath = partition.getDataLocation();
            fs = partPath.getFileSystem((Configuration)this.conf);
            if (!fs.exists(partPath)) {
                CheckResult.PartitionResult pr = new CheckResult.PartitionResult();
                pr.setPartitionName(partition.getName());
                pr.setTableName(partition.getTable().getTableName());
                result.getPartitionsNotOnFs().add(pr);
            }
            for (int i = 0; i < partition.getSpec().size(); ++i) {
                partPaths.add(partPath.makeQualified(fs));
                partPath = partPath.getParent();
            }
        }
        if (findUnknownPartitions) {
            this.findUnknownPartitions(table, partPaths, result);
        }
    }

    void findUnknownPartitions(Table table, Set<Path> partPaths, CheckResult result) throws IOException, HiveException {
        Path tablePath = table.getPath();
        HashSet<Path> allPartDirs = new HashSet<Path>();
        this.checkPartitionDirs(tablePath, allPartDirs, table.getPartCols().size());
        allPartDirs.remove(tablePath);
        allPartDirs.removeAll(partPaths);
        for (Path partPath : allPartDirs) {
            FileSystem fs = partPath.getFileSystem((Configuration)this.conf);
            String partitionName = this.getPartitionName(fs.makeQualified(tablePath), partPath);
            if (partitionName == null) continue;
            CheckResult.PartitionResult pr = new CheckResult.PartitionResult();
            pr.setPartitionName(partitionName);
            pr.setTableName(table.getTableName());
            result.getPartitionsNotInMs().add(pr);
        }
    }

    private String getPartitionName(Path tablePath, Path partitionPath) {
        String result = null;
        for (Path currPath = partitionPath; currPath != null && !tablePath.equals((Object)currPath); currPath = currPath.getParent()) {
            result = result == null ? currPath.getName() : currPath.getName() + "/" + result;
        }
        return result;
    }

    private void checkPartitionDirs(Path basePath, Set<Path> allDirs, int maxDepth) throws IOException, HiveException {
        ConcurrentLinkedQueue<Path> basePaths = new ConcurrentLinkedQueue<Path>();
        basePaths.add(basePath);
        Set<Path> dirSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.checkPartitionDirs(basePaths, dirSet, basePath.getFileSystem((Configuration)this.conf), maxDepth, maxDepth);
        allDirs.addAll(dirSet);
    }

    private void checkPartitionDirs(ConcurrentLinkedQueue<Path> basePaths, Set<Path> allDirs, FileSystem fs, int depth, int maxDepth) throws IOException, HiveException {
        ConcurrentLinkedQueue<Path> nextLevel = new ConcurrentLinkedQueue<Path>();
        for (Path path : basePaths) {
            FileStatus[] statuses;
            for (FileStatus status : statuses = fs.listStatus(path, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (!status.isDirectory()) continue;
                nextLevel.add(status.getPath());
            }
            if (depth != 0) {
                if (!nextLevel.isEmpty()) {
                    this.checkPartitionDirs(nextLevel, allDirs, fs, depth - 1, maxDepth);
                    continue;
                }
                if (depth == maxDepth) continue;
                continue;
            }
            allDirs.add(path);
        }
    }
}

