/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

public class DataWritableWriter {
    private static final Log LOG = LogFactory.getLog(DataWritableWriter.class);
    private final RecordConsumer recordConsumer;
    private final GroupType schema;

    public DataWritableWriter(RecordConsumer recordConsumer, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.schema = schema;
    }

    public void write(ParquetHiveRecord record) {
        if (record != null) {
            this.recordConsumer.startMessage();
            try {
                this.writeGroupFields(record.getObject(), record.getObjectInspector(), this.schema);
            }
            catch (RuntimeException e) {
                String errorMessage = "Parquet record is malformed: " + e.getMessage();
                LOG.error((Object)errorMessage, (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
            this.recordConsumer.endMessage();
        }
    }

    private void writeGroupFields(Object value, StructObjectInspector inspector, GroupType type) {
        if (value != null) {
            List<? extends StructField> fields = inspector.getAllStructFieldRefs();
            List<Object> fieldValuesList = inspector.getStructFieldsDataAsList(value);
            for (int i = 0; i < type.getFieldCount(); ++i) {
                Type fieldType = type.getType(i);
                String fieldName = fieldType.getName();
                Object fieldValue = fieldValuesList.get(i);
                if (fieldValue == null) continue;
                ObjectInspector fieldInspector = fields.get(i).getFieldObjectInspector();
                this.recordConsumer.startField(fieldName, i);
                this.writeValue(fieldValue, fieldInspector, fieldType);
                this.recordConsumer.endField(fieldName, i);
            }
        }
    }

    private void writeValue(Object value, ObjectInspector inspector, Type type) {
        if (type.isPrimitive()) {
            this.checkInspectorCategory(inspector, ObjectInspector.Category.PRIMITIVE);
            this.writePrimitive(value, (PrimitiveObjectInspector)inspector);
        } else {
            GroupType groupType = type.asGroupType();
            OriginalType originalType = type.getOriginalType();
            if (originalType != null && originalType.equals((Object)OriginalType.LIST)) {
                this.checkInspectorCategory(inspector, ObjectInspector.Category.LIST);
                this.writeArray(value, (ListObjectInspector)inspector, groupType);
            } else if (originalType != null && originalType.equals((Object)OriginalType.MAP)) {
                this.checkInspectorCategory(inspector, ObjectInspector.Category.MAP);
                this.writeMap(value, (MapObjectInspector)inspector, groupType);
            } else {
                this.checkInspectorCategory(inspector, ObjectInspector.Category.STRUCT);
                this.writeGroup(value, (StructObjectInspector)inspector, groupType);
            }
        }
    }

    private void checkInspectorCategory(ObjectInspector inspector, ObjectInspector.Category category) {
        if (!inspector.getCategory().equals((Object)category)) {
            throw new IllegalArgumentException("Invalid data type: expected " + (Object)((Object)category) + " type, but found: " + (Object)((Object)inspector.getCategory()));
        }
    }

    private void writeGroup(Object value, StructObjectInspector inspector, GroupType type) {
        this.recordConsumer.startGroup();
        this.writeGroupFields(value, inspector, type);
        this.recordConsumer.endGroup();
    }

    private void writeArray(Object value, ListObjectInspector inspector, GroupType type) {
        GroupType repeatedType = type.getType(0).asGroupType();
        this.recordConsumer.startGroup();
        List<?> arrayValues = inspector.getList(value);
        if (arrayValues != null && arrayValues.size() > 0) {
            this.recordConsumer.startField(repeatedType.getName(), 0);
            ObjectInspector elementInspector = inspector.getListElementObjectInspector();
            Type elementType = repeatedType.getType(0);
            String elementName = elementType.getName();
            for (Object element : arrayValues) {
                this.recordConsumer.startGroup();
                if (element != null) {
                    this.recordConsumer.startField(elementName, 0);
                    this.writeValue(element, elementInspector, elementType);
                    this.recordConsumer.endField(elementName, 0);
                }
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(repeatedType.getName(), 0);
        }
        this.recordConsumer.endGroup();
    }

    private void writeMap(Object value, MapObjectInspector inspector, GroupType type) {
        GroupType repeatedType = type.getType(0).asGroupType();
        this.recordConsumer.startGroup();
        Map<?, ?> mapValues = inspector.getMap(value);
        if (mapValues != null && mapValues.size() > 0) {
            this.recordConsumer.startField(repeatedType.getName(), 0);
            Type keyType = repeatedType.getType(0);
            String keyName = keyType.getName();
            ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
            Type valuetype = repeatedType.getType(1);
            String valueName = valuetype.getName();
            ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
            for (Map.Entry<?, ?> keyValue : mapValues.entrySet()) {
                this.recordConsumer.startGroup();
                if (keyValue != null) {
                    Object keyElement = keyValue.getKey();
                    this.recordConsumer.startField(keyName, 0);
                    this.writeValue(keyElement, keyInspector, keyType);
                    this.recordConsumer.endField(keyName, 0);
                    Object valueElement = keyValue.getValue();
                    if (valueElement != null) {
                        this.recordConsumer.startField(valueName, 1);
                        this.writeValue(valueElement, valueInspector, valuetype);
                        this.recordConsumer.endField(valueName, 1);
                    }
                }
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(repeatedType.getName(), 0);
        }
        this.recordConsumer.endGroup();
    }

    private void writePrimitive(Object value, PrimitiveObjectInspector inspector) {
        if (value == null) {
            return;
        }
        switch (inspector.getPrimitiveCategory()) {
            case VOID: {
                return;
            }
            case DOUBLE: {
                this.recordConsumer.addDouble(((DoubleObjectInspector)inspector).get(value));
                break;
            }
            case BOOLEAN: {
                this.recordConsumer.addBoolean(((BooleanObjectInspector)inspector).get(value));
                break;
            }
            case FLOAT: {
                this.recordConsumer.addFloat(((FloatObjectInspector)inspector).get(value));
                break;
            }
            case BYTE: {
                this.recordConsumer.addInteger(((ByteObjectInspector)inspector).get(value));
                break;
            }
            case INT: {
                this.recordConsumer.addInteger(((IntObjectInspector)inspector).get(value));
                break;
            }
            case LONG: {
                this.recordConsumer.addLong(((LongObjectInspector)inspector).get(value));
                break;
            }
            case SHORT: {
                this.recordConsumer.addInteger(((ShortObjectInspector)inspector).get(value));
                break;
            }
            case STRING: {
                String v = ((StringObjectInspector)inspector).getPrimitiveJavaObject(value);
                this.recordConsumer.addBinary(Binary.fromString(v));
                break;
            }
            case CHAR: {
                String vChar = ((HiveCharObjectInspector)inspector).getPrimitiveJavaObject(value).getStrippedValue();
                this.recordConsumer.addBinary(Binary.fromString(vChar));
                break;
            }
            case VARCHAR: {
                String vVarchar = ((HiveVarcharObjectInspector)inspector).getPrimitiveJavaObject(value).getValue();
                this.recordConsumer.addBinary(Binary.fromString(vVarchar));
                break;
            }
            case BINARY: {
                byte[] vBinary = ((BinaryObjectInspector)inspector).getPrimitiveJavaObject(value);
                this.recordConsumer.addBinary(Binary.fromByteArray(vBinary));
                break;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampObjectInspector)inspector).getPrimitiveJavaObject(value);
                this.recordConsumer.addBinary(NanoTimeUtils.getNanoTime(ts, false).toBinary());
                break;
            }
            case DECIMAL: {
                HiveDecimal vDecimal = (HiveDecimal)inspector.getPrimitiveJavaObject(value);
                DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)inspector.getTypeInfo();
                this.recordConsumer.addBinary(this.decimalToBinary(vDecimal, decTypeInfo));
                break;
            }
            case DATE: {
                Date vDate = ((DateObjectInspector)inspector).getPrimitiveJavaObject(value);
                this.recordConsumer.addInteger(DateWritable.dateToDays(vDate));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported primitive data type: " + (Object)((Object)inspector.getPrimitiveCategory()));
            }
        }
    }

    private Binary decimalToBinary(HiveDecimal hiveDecimal, DecimalTypeInfo decimalTypeInfo) {
        int scale;
        byte[] decimalBytes;
        int prec = decimalTypeInfo.precision();
        int precToBytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
        if (precToBytes == (decimalBytes = hiveDecimal.setScale(scale = decimalTypeInfo.scale()).unscaledValue().toByteArray()).length) {
            return Binary.fromByteArray(decimalBytes);
        }
        byte[] tgt = new byte[precToBytes];
        if (hiveDecimal.signum() == -1) {
            int i = 0;
            while (i < precToBytes) {
                int n = i++;
                tgt[n] = (byte)(tgt[n] | 0xFF);
            }
        }
        System.arraycopy(decimalBytes, 0, tgt, precToBytes - decimalBytes.length, decimalBytes.length);
        return Binary.fromByteArray(tgt);
    }
}

